use aoko::no_std::algebraic::sum::TimeUnit;
use clap::Parser;

/// Attack Incident Analysis Report Generator

#[derive(Parser)]
#[clap(version = "0.0.0", author = "hzqd <hzqelf@yeah.net>")]
pub struct Args {
    /// Specify the hacked project name
    #[clap(short, long)]
    pub project: String,

    /// The hacked project introduction
    #[clap(short, long, default_value = "")]
    pub introduction: String,

    /// The blockchain platform
    #[clap(short, long, default_value = "")]
    pub chain: String,

    /// The date the project party stated that it was attacked;
    /// Split by `.`
    #[clap(short, long, default_value = "")]
    pub date: String,

    /// Hacker's wallet(s);
    /// Split by `,`
    #[clap(short, long, default_value = "")]
    pub exploiter_wallet: String,

    /// Main attack contract(s) address;
    /// Split by `,`
    #[clap(short, long, default_value = "")]
    pub main_attack_contract: String,

    /// Token contract(s) address;
    /// Split by `,`
    #[clap(short, long, default_value = "")]
    pub token_contract: String,

    /// Attack transaction(s);
    /// Split by `,`
    #[clap(short, long, default_value = "")]
    pub attack_transaction: String,

    /// Vulnerability contract(s) name;
    /// Split by `,`
    #[clap(short, long, default_value = "")]
    pub unprotected_contract_name: String,

    /// Vulnerability contract(s) address;
    /// Split by `,`
    #[clap(short, long, default_value = "")]
    pub vul_contract: String,

    /// Transaction picture(s) path;
    /// Split by `,`
    #[clap(long, default_value = "")]
    pub tx: String,

    /// Attack times
    #[clap(short, long, default_value = "")]
    pub number_of_attacks: String,

    /// Attack on Profitable Money
    #[clap(short, long, default_value = "")]
    pub stolen_money: String,

    /// Main attack way
    #[clap(short, long, default_value = "")]
    pub way: String,

    /// Specify the time unit, support nanos, micros, millis, secs
    #[clap(long, default_value = "micros")]
    pub time: TimeUnit,
}

pub fn get_args() -> Args {
    Args::parse()
}