use crate::cli::get_args;
use std::{fs, time::Duration};
use aoko::{no_std::{pipelines::pipe::Pipe, algebraic::sum::TimeUnit, functions::ext::StrExt}, standard::functions::fun::time_conversion_with_unit};
use itertools::Itertools;

pub fn aia() -> (impl FnOnce(Duration)-> u128, TimeUnit) {
    let (project, introduction, chain, time, tx, date,
        main_attack_contract, exploiter_wallet, token_contract, attack_transaction,
        vul_contract, vul_contract_name, number_of_attacks, stolen_money, way) = 
        get_args().pipe(|s| (
            s.project, s.introduction, s.chain, s.time,
            s.tx.split(",")
                .enumerate()
                .map(|(number, picture)| format!("**步骤{number}:** \n\n![tx]({picture}.png)"))
                .join("\n\n"),
            s.date.split(".").map(|s| s.to_owned()).collect_vec(),
            s.main_attack_contract.split_not_empty_and_join(",", "\n- "),
            s.exploiter_wallet.split_not_empty_and_join(",", "\n- "),
            s.token_contract.split_not_empty_and_join(",", "\n- "),
            s.attack_transaction.split_not_empty_and_join(",", "\n- "),
            s.vul_contract.split_not_empty_and_join(",", "\n- "),
            s.unprotected_contract_name.split_not_empty_and_join(",", "、"),
            s.number_of_attacks, s.stolen_money, s.way,
        ));
    
    let (year, month, day) = (&date[0], &date[1], &date[2]);

    let file_name = format!("零时科技 | {project} 攻击事件分析");

    let vul_contract_name_and_addr =
        vul_contract_name.split(" 、 ").zip(vul_contract.split("\n- "))
            .map(|(name, addr)| format!("{name}: {addr}"))
            .join("\n- ");

    let content = format!(r#"# {file_name}
## 0x1 事件背景
{introduction}

零时科技区块链安全情报平台监控到消息，北京时间 {year} 年 {month} 月 {day} 日，{project} 称遭到黑客攻击，零时科技安全团队及时对此安全事件进行分析。

## 0x2 攻击者信息
零时科技安全团队通过初步追踪分析，此次攻击发生在 {chain} 链，主要攻击信息如下:

**攻击者钱包地址**:
- {exploiter_wallet}

**攻击者创建的相关合约地址**:
- {main_attack_contract}

**token 合约**：
- {token_contract}

**攻击交易流程**：
- {attack_transaction}

**官方漏洞合约**:
- {vul_contract_name_and_addr}

## 0x3 攻击分析

先来看看攻击者获利的一组交易操作：

{tx}

至此，攻击者利用此攻击流程，通过对官方 {vul_contract_name} 合约进行了 {number_of_attacks} 次攻击共获利约{stolen_money}。

## 0x5 总结

通过此次攻击事件来看，攻击成功最重要的因素是 {project} 官方的 {vul_contract_name} 合约中：没有对xxx做xxx(效验/限制)。攻击者可以通过{way}对项目造成威胁。对于此类安全事件，零时科技安全团队给出下述安全建议。

## 0x6 安全建议

- xx
"#);

    fs::write(file_name + ".md", content).unwrap();

    time_conversion_with_unit(time)
}