use libflate::gzip::Encoder;
use std::{env, fs, io::Write};

fn main() {
    println!("cargo:rerun-if-changed=src/word_list.txt");

    let list = fs::read_to_string("src/word_list.txt")
        .expect("couldn't read word list")
        .to_lowercase();

    let mut encoder = Encoder::new(Vec::new()).expect("Failed to create compressor");

    encoder
        .write_all(list.as_bytes())
        .expect("Failed to write data");

    let compressed = encoder
        .finish()
        .into_result()
        .expect("Failed to finalize compressed data");

    fs::write(
        format!("{}/{}", env::var("OUT_DIR").unwrap(), "word_list.gz"),
        compressed,
    )
    .expect(&format!(
        "Failed to write compressed dictionary to `{}/word_list.gz`",
        env::var("OUT_DIR").unwrap()
    ));
}
