# agram
An anagram library for Rust.

Add to your Cargo.toml:
```
agram = "1.0"
```

Basic example:
```rust
use std::env;

fn main() {
    let anagrams = agram::get(env::args().nth(1).expect("You must provide a word"));

    println!("count: {}", anagrams.count);
    for word in anagrams.words {
        println!("   {word}");
    }
}
```

```shell
$ cargo build --release --example basic
$ target/release/examples/basic thing
count: 1
   night
```

## Runtime Decompression
The word list is compressed at build time, then decompressed using gzip at runtime. This saves us quite a bit of space in the binary with the drawback that your first request will take a little longer while the library decompresses the list into memory. You can make this faster by calling the `init` function in the library.

```
word list: 4.7M
example binary before compression: 8.1M
example binary after compression: 5.0M
```