use aga8::Detail;

#[allow(clippy::cognitive_complexity)]
#[test]
fn gas_1() {
    let mut aga8_test: Detail = Detail::default();
    aga8_test.setup();
    aga8_test.x = [
        0.965_000, // Methane
        0.003_000, // Nitrogen
        0.006_000, // Carbon dioxide
        0.018_000, // Ethane
        0.004_500, // Propane
        0.001_000, // Isobutane
        0.001_000, // n-Butane
        0.000_500, // Isopentane
        0.000_300, // n-Pentane
        0.000_700, // Hexane
        0.000_000, // Heptane
        0.000_000, // Octane
        0.000_000, // Nonane
        0.000_000, // Decane
        0.000_000, // Hydrogen
        0.000_000, // Oxygen
        0.000_000, // Carbon monoxide
        0.000_000, // Water
        0.000_000, // Hydrogen sulfide
        0.000_000, // Helium
        0.000_000, // Argon
    ];
    aga8_test.t = 250.0; // [K]
    aga8_test.p = 5_000.0; // [kPa]
    aga8_test.density_detail();
    aga8_test.properties_detail();

    // Compression factor [-] 4
    assert!(f64::abs(aga8_test.z - 0.819_96) < 0.000_1);
    // Density [kg/m³] 2
    assert!(f64::abs(aga8_test.d * aga8_test.mm - 49.295) < 0.01);
    // Specific internal energy [kJ/kg] 1
    assert!(f64::abs(aga8_test.u / aga8_test.mm - -280.49) < 0.1);
    // Specific enthalpy [kJ/kg] 1
    assert!(f64::abs(aga8_test.h / aga8_test.mm - -179.06) < 0.1);
    // Specific entropy [kJ/kg⋅K] 1
    assert!(f64::abs(aga8_test.s / aga8_test.mm - -2.422_3) < 0.1);
    // Specific isochoric heat capacity [kJ/kg⋅K] 3
    assert!(f64::abs(aga8_test.cv / aga8_test.mm - 1.690_6) < 0.001);
    // Specific isobaric heat capacity [kJ/kg⋅K] 3
    assert!(f64::abs(aga8_test.cp / aga8_test.mm - 2.834_2) < 0.001);
    // Joule-Thomson coefficient [K/MPa] 2
    assert!(f64::abs(aga8_test.jt * 1.0e3 - 6.153) < 0.01);
    // Isentropic exponent [-] 2
    assert!(f64::abs(aga8_test.kappa - 1.366) < 0.01);
    // Speed of sound [m/s] 1
    assert!(f64::abs(aga8_test.w - 372.27) < 0.1);

    aga8_test.t = 260.0; // [K]
    aga8_test.p = 5_000.0; // [kPa]
    aga8_test.density_detail();
    aga8_test.properties_detail();

    // Compression factor [-] 4
    assert!(f64::abs(aga8_test.z - 0.845_44) < 0.000_1);
    // Density [kg/m³] 2
    assert!(f64::abs(aga8_test.d * aga8_test.mm - 45.971) < 0.01);
    // Specific internal energy [kJ/kg] 1
    assert!(f64::abs(aga8_test.u / aga8_test.mm - -260.09) < 0.1);
    // Specific enthalpy [kJ/kg] 1
    assert!(f64::abs(aga8_test.h / aga8_test.mm - -151.32) < 0.1);
    // Specific entropy [kJ/kg⋅K] 1
    assert!(f64::abs(aga8_test.s / aga8_test.mm - -2.313_4) < 0.1);
    // Specific isochoric heat capacity [kJ/kg⋅K] 3
    assert!(f64::abs(aga8_test.cv / aga8_test.mm - 1.691_0) < 0.001);
    // Specific isobaric heat capacity [kJ/kg⋅K] 3
    assert!(f64::abs(aga8_test.cp / aga8_test.mm - 2.721_9) < 0.001);
    // Joule-Thomson coefficient [K/MPa] 2
    assert!(f64::abs(aga8_test.jt * 1.0e3 - 5.658) < 0.01);
    // Isentropic exponent [-] 2
    assert!(f64::abs(aga8_test.kappa - 1.360) < 0.01);
    // Speed of sound [m/s] 1
    assert!(f64::abs(aga8_test.w - 384.59) < 0.1);

    aga8_test.t = 270.0; // [K]
    aga8_test.p = 5_000.0; // [kPa]
    aga8_test.density_detail();
    aga8_test.properties_detail();

    // Compression factor [-] 4
    assert!(f64::abs(aga8_test.z - 0.866_43) < 0.000_1);
    // Density [kg/m³] 2
    assert!(f64::abs(aga8_test.d * aga8_test.mm - 43.196) < 0.01);
    // Specific internal energy [kJ/kg] 1
    assert!(f64::abs(aga8_test.u / aga8_test.mm - -240.26) < 0.1);
    // Specific enthalpy [kJ/kg] 1
    assert!(f64::abs(aga8_test.h / aga8_test.mm - -124.51) < 0.1);
    // Specific entropy [kJ/kg⋅K] 1
    assert!(f64::abs(aga8_test.s / aga8_test.mm - -2.212_2) < 0.1);
    // Specific isochoric heat capacity [kJ/kg⋅K] 3
    assert!(f64::abs(aga8_test.cv / aga8_test.mm - 1.696_3) < 0.001);
    // Specific isobaric heat capacity [kJ/kg⋅K] 3
    assert!(f64::abs(aga8_test.cp / aga8_test.mm - 2.645_0) < 0.001);
    // Joule-Thomson coefficient [K/MPa] 2
    assert!(f64::abs(aga8_test.jt * 1.0e3 - 5.219) < 0.01);
    // Isentropic exponent [-] 2
    assert!(f64::abs(aga8_test.kappa - 1.354) < 0.01);
    // Speed of sound [m/s] 1
    assert!(f64::abs(aga8_test.w - 395.93) < 0.1);
}

#[allow(clippy::cognitive_complexity)]
#[test]
fn gas_6() {
    let mut aga8_test: Detail = Detail::default();
    aga8_test.setup();
    aga8_test.x = [
        0.825_198, // Methane
        0.117_266, // Nitrogen
        0.011_093, // Carbon dioxide
        0.034_611, // Ethane
        0.007_645, // Propane
        0.000_000, // Isobutane
        0.002_539, // n-Butane
        0.000_000, // Isopentane
        0.000_746, // n-Pentane
        0.000_225, // Hexane
        0.000_110, // Heptane
        0.000_029, // Octane
        0.000_000, // Nonane
        0.000_000, // Decane
        0.000_000, // Hydrogen
        0.000_000, // Oxygen
        0.000_000, // Carbon monoxide
        0.000_000, // Water
        0.000_000, // Hydrogen sulfide
        0.000_538, // Helium
        0.000_000, // Argon
    ];
    aga8_test.t = 250.0; // [K]
    aga8_test.p = 5_000.0; // [kPa]
    aga8_test.density_detail();
    aga8_test.properties_detail();

    // Compression factor [-] 4
    assert!(f64::abs(aga8_test.z - 0.834_09) < 0.000_1);
    // Density [kg/m³] 2
    assert!(f64::abs(aga8_test.d * aga8_test.mm - 53.718) < 0.01);
    // Specific internal energy [kJ/kg] 1
    assert!(f64::abs(aga8_test.u / aga8_test.mm - -249.86) < 0.1);
    // Specific enthalpy [kJ/kg] 1
    assert!(f64::abs(aga8_test.h / aga8_test.mm - -156.78) < 0.1);
    // Specific entropy [kJ/kg⋅K] 1
    assert!(f64::abs(aga8_test.s / aga8_test.mm - -1.976_6) < 0.1);
    // Specific isochoric heat capacity [kJ/kg⋅K] 3
    assert!(f64::abs(aga8_test.cv / aga8_test.mm - 1.504_7) < 0.001);
    // Specific isobaric heat capacity [kJ/kg⋅K] 3
    assert!(f64::abs(aga8_test.cp / aga8_test.mm - 2.486_6) < 0.001);
    // Joule-Thomson coefficient [K/MPa] 2
    assert!(f64::abs(aga8_test.jt * 1.0e3 - 5.831) < 0.01);
    // Isentropic exponent [-] 2
    assert!(f64::abs(aga8_test.kappa - 1.377) < 0.01);
    // Speed of sound [m/s] 1
    assert!(f64::abs(aga8_test.w - 358.07) < 0.1);

    aga8_test.t = 260.0; // [K]
    aga8_test.p = 5_000.0; // [kPa]
    aga8_test.density_detail();
    aga8_test.properties_detail();

    // Compression factor [-] 4
    assert!(f64::abs(aga8_test.z - 0.857_65) < 0.000_1);
    // Density [kg/m³] 2
    assert!(f64::abs(aga8_test.d * aga8_test.mm - 50.234) < 0.01);
    // Specific internal energy [kJ/kg] 1
    assert!(f64::abs(aga8_test.u / aga8_test.mm - -231.91) < 0.1);
    // Specific enthalpy [kJ/kg] 1
    assert!(f64::abs(aga8_test.h / aga8_test.mm - -132.38) < 0.1);
    // Specific entropy [kJ/kg⋅K] 1
    assert!(f64::abs(aga8_test.s / aga8_test.mm - -1.880_9) < 0.1);
    // Specific isochoric heat capacity [kJ/kg⋅K] 3
    assert!(f64::abs(aga8_test.cv / aga8_test.mm - 1.506_0) < 0.001);
    // Specific isobaric heat capacity [kJ/kg⋅K] 3
    assert!(f64::abs(aga8_test.cp / aga8_test.mm - 2.399_5) < 0.001);
    // Joule-Thomson coefficient [K/MPa] 2
    assert!(f64::abs(aga8_test.jt * 1.0e3 - 5.369) < 0.01);
    // Isentropic exponent [-] 2
    assert!(f64::abs(aga8_test.kappa - 1.370) < 0.01);
    // Speed of sound [m/s] 1
    assert!(f64::abs(aga8_test.w - 369.34) < 0.1);

    aga8_test.t = 270.0; // [K]
    aga8_test.p = 5_000.0; // [kPa]
    aga8_test.density_detail();
    aga8_test.properties_detail();

    // Compression factor [-] 4
    assert!(f64::abs(aga8_test.z - 0.877_16) < 0.000_1);
    // Density [kg/m³] 2
    assert!(f64::abs(aga8_test.d * aga8_test.mm - 47.297) < 0.01);
    // Specific internal energy [kJ/kg] 1
    assert!(f64::abs(aga8_test.u / aga8_test.mm - -214.42) < 0.1);
    // Specific enthalpy [kJ/kg] 1
    assert!(f64::abs(aga8_test.h / aga8_test.mm - -108.71) < 0.1);
    // Specific entropy [kJ/kg⋅K] 1
    assert!(f64::abs(aga8_test.s / aga8_test.mm - -1.791_6) < 0.1);
    // Specific isochoric heat capacity [kJ/kg⋅K] 3
    assert!(f64::abs(aga8_test.cv / aga8_test.mm - 1.511_1) < 0.001);
    // Specific isobaric heat capacity [kJ/kg⋅K] 3
    assert!(f64::abs(aga8_test.cp / aga8_test.mm - 2.338_7) < 0.001);
    // Joule-Thomson coefficient [K/MPa] 2
    assert!(f64::abs(aga8_test.jt * 1.0e3 - 4.959) < 0.01);
    // Isentropic exponent [-] 2
    assert!(f64::abs(aga8_test.kappa - 1.364) < 0.01);
    // Speed of sound [m/s] 1
    assert!(f64::abs(aga8_test.w - 379.78) < 0.1);
}
