pub trait Stream {
    type Item;

    // 返回流的当前元素
    fn car(&self) -> Option<Self::Item>;

    // 返回流的下一个元素，支持延迟
    fn cdr(&self) -> Option<Box<dyn Stream<Item = Self::Item>>>;
}

pub struct SteamIterator<T> {
    stream: Option<Box<dyn Stream<Item = T>>>,
}

impl<T> SteamIterator<T> {
    pub fn new(s: Option<Box<dyn Stream<Item = T>>>) -> Self {
        SteamIterator{stream:s}
    }
}

impl<T> Iterator for SteamIterator<T> {
    type Item = T;
    fn next(&mut self) -> Option<Self::Item> {
        if let Some(stream) = &mut self.stream {
            let car = stream.car();
            self.stream = stream.cdr();
            car
        } else {
            None
        }
    }
}
