use crate::search::database::get_connect;

use futures::TryStreamExt;
use sqlx::Row;
use async_std::task;

pub type ClosureType = Box<dyn FnOnce() + Send>;

#[derive(Debug)]
pub struct Update {
    // 保存最后一次更新时间
    pub last_time: i64,
    // 本次更新时间
    pub this_time: i64,
}

impl Update {
    pub fn new() -> Self {
        let this_time = task::block_on(async {
            now().await.expect("取系统时间错误")
        });
        Update{last_time:0, this_time:this_time}
    }

    pub fn next(&self) -> Self {
        let this_time = task::block_on(async {
            now().await.expect("取系统时间错误")
        });
        Update{last_time: self.this_time, this_time:this_time}
    }
}

// 获取数据库服务器当前时间
async fn now() -> Result<i64, sqlx::Error> {
    let mut conn = get_connect().await?;
    let sql = "select convert(BIGINT,@@dbts) time";
    let mut rows = sqlx::query(&sql).fetch(&mut conn);
    let row = rows.try_next().await?.unwrap();
    let result: i64 = row.try_get("time").expect("获取数据错误");
    Ok(result)
}
