# 文件说明

核心代码在path目录下，利用path目录产生的宏，生成目标代码，path目录源文件说明：

* lib.rs：提供了如下宏：
  - tables：用于产生数据库的表声明，根据`tables.json`文件，产生全局数据库表。具体实现在`tables.rs`中。
  - structs：用于产生每个表对应的数据结构，根据`tables.json`内容，产生各种structs。具体实现在`structs.rs`中。
  - path：用于把`query`目录下的查询转换成rust代码。实现内容见下方。
  _ insert_data：用于插入测试数据，单元测试用。

* structs.rs：产生表的结构
* tables.rs：产生数据库结构
* json.rs：提供`tables.json`的访问。

## path实现

path实现靠下面几个文件：

* token.rs：提供了单词读取过程的包装，主要为了支持单词回退。提供了一个支持单词回退的迭代。
* program.rs：语法解析，提供path语言的核心解析过程，解析按递归下降方法来做的。
* expression.rs：用于把解析后的语法树转换成rust代码，插入到rust源程序中，主要处理Query结构。

## 主程序文件

主程序核心文件在search包下，内容有：

* database.rs：提供数据库核心操作，包括：
  - load函数：加载数据库，并根据`tables.json`文件创建一对多，一对一关系。
  - search函数：执行前端传过来的查询请求，在这里定义path语言要调用的rust函数。
  - select：私有函数，用于把path查询的结果最终转换成json字符串。

* table.rs：数据库表的公用结构，内容有：
  - trait Entity：所有表结构均需实现new方法，用来创建一条记录实例。
  - struct Table<T>：数据库表通用范型，主要提供`load_data`方法，用于加载表中数据。
  - get_sql：私有函数，根据`tables.json`文件内容，产生获取数据的sql语句。

## test包

test包的`util.rs`存放产生测试数据的工具。

## util包

util包的`json.rs`存放`tables.json`的访问工具，与path中的重复了，后面考虑合并。

## bin.rs

程序入口主文件。

## update.rs

用于产生每次更新数据库时的流。

## gas包

- entity.rs：存放所有数据库表结构，这些表结构由`structs`宏产生。

# path中要使用的函数

目前在`src/search/database.rs`中定义，后续考虑，单独一个文件，放到gas目录下。