#![macro_use] extern crate criterion;
extern crate mylib;

use mylib::search::database;
use mylib::gas::entity;
use mylib::test::util::create_data;

use criterion::*;
use std::alloc;
use itertools::Itertools;
use std::collections::HashMap;

fn create() {
    // 根据描述创建数据
    create_data("large.data.json");
    // 加载并创建关系
    database::init();
}

fn bench(c: &mut Criterion) {
    let str = "{\"address\":\"西安软件园\", \"start\":\"2021-01-01T00:00:00\", \"end\":\"2021-12-31T23:59:59\"}";
    let params: serde_json::Value = serde_json::from_str(str).unwrap();
    create();
    // 显示数据库占用内存
    println!("内存占用：{:?}", alloc::Layout::for_value(unsafe{&database::DATABASE}));

    c.bench_function("iter", move |b| {
        b.iter_with_large_drop(
            || database::search_page("monthgas", &params, 900, 100).unwrap()
        )
    });
}

// 测试分组性能
fn bench_group(c: &mut Criterion) {
    let str = "{\"address\":\"西安软件园\", \"start\":\"2021-01-01T00:00:00\", \"end\":\"2021-12-31T23:59:59\"}";
    let params: serde_json::Value = serde_json::from_str(str).unwrap();
    create();
    // 显示数据库占用内存
    println!("内存占用：{:?}", alloc::Layout::for_value(unsafe{&database::DATABASE}));

    c.bench_function("iter", move |b| {
        b.iter_with_large_drop(
            || {
                unsafe {
                    let v = database::DATABASE.t_sellinggas.data.values().into_iter();
                    let lookup: HashMap<i32,Vec<&entity::t_sellinggas>> = v.filter(|x| {
                        x.f_userinfo_id < 1000
                    }).into_group_map_by(
                        |a| a.f_userinfo_id % 10
                    );
                }
            }
        )
    });
}

criterion_group!(benches, bench_group);
criterion_main!(benches);