#[derive(Clone)]

pub struct Matrix<T: Clone> {
    size: (usize, usize),
    data: Vec<T>,
    default: T
}

impl<T: Clone> Matrix<T> {
    pub fn new(new_width: usize, new_height: usize, new_default: T) -> Self {
        Matrix {
            size: (new_width, new_height),
            data: vec![new_default.clone(); new_width * new_height],
            default: new_default,
        }
    }
}

use std::fmt;
impl<T: Clone + fmt::Debug> fmt::Debug for Matrix<T> {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        // 这里将 size 类型分解为宽和高
        let (width, height) = self.size;
        let mut debug_string = "".to_string();
        for h in 0..height {
            for w in 0..width {
                // format 宏的返回值总是 String 类型的
                debug_string += &*format!("{:?}, ", self.data[h*width+w]);
            }
            // 输入完一行之后需要增加一个换行符
            debug_string.push('\n');
        }  
        write!(f, "{}", debug_string)
    }
}