//! Counter Wrap Tests
//!
//! The tests use `Aes256GcmSiv` and are crafted to test correct wrapping of
//! the block counter.

#[macro_use]
mod common;

use self::common::TestVector;
use aes_gcm_siv::aead::{generic_array::GenericArray, Aead, NewAead, Payload};
use aes_gcm_siv::Aes256GcmSiv;

/// Test vectors from RFC8452 Appendix C.3. Counter Wrap Tests
/// <https://tools.ietf.org/html/rfc8452#appendix-C.3>
const TEST_VECTORS: &[TestVector<[u8; 32]>] = &[
    TestVector {
        key: b"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
        nonce: b"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
        aad: b"",
        plaintext: b"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4d\xb9\x23\xdc\x79\x3e\xe6\x49\x7c\x76\xdc\xc0\x3a\x98\xe1\x08",
        ciphertext: b"\xf3\xf8\x0f\x2c\xf0\xcb\x2d\xd9\xc5\x98\x4f\xcd\xa9\x08\x45\x6c\xc5\x37\x70\x3b\x5b\xa7\x03\x24\xa6\x79\x3a\x7b\xf2\x18\xd3\xea\xff\xff\xff\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
    },
    TestVector {
        key: b"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
        nonce: b"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
        aad: b"",
        plaintext: b"\xeb\x36\x40\x27\x7c\x7f\xfd\x13\x03\xc7\xa5\x42\xd0\x2d\x3e\x4c\x00\x00\x00\x00\x00\x00\x00\x00",
        ciphertext: b"\x18\xce\x4f\x0b\x8c\xb4\xd0\xca\xc6\x5f\xea\x8f\x79\x25\x7b\x20\x88\x8e\x53\xe7\x22\x99\xe5\x6d\xff\xff\xff\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
    },
];

tests!(Aes256GcmSiv, TEST_VECTORS);
