# Contributing

[advent_of_code_traits][crates-io] welcomes contributions from everyone. This document
explains how you can contribute and how to get started.

If you have any questions about contributing or need help with
anything, feel free to ask questions on issues.

This is a friendly place to contribute. It's a small, low-pressure library that is used for fun, enjoy yourself.

All contributors are expected to follow the [Rust Code of Conduct].

Please follow the following steps to help keep things running smoothly.

* Fork this repository on GitHub
* Clone your fork:
```
git clone https://github.com/drmason13/advent_of_code_traits
```
* make your code changes
* run `cargo test` to ensure the examples still compile
* commit with a message briefly describing what applying the commit does
```
git add -A
git commit -m "Add this awesome new feature"
```
* Submit a Pull request on GitHub
* Wait patiently for me to respond, this could be a while, please don't be offended.
* I'll wait patiently for you to respond to my comments on your pull request, fair is fair :)

## Thank you for contributing!

[Rust Code of Conduct]: https://www.rust-lang.org/policies/code-of-conduct

## Looking for ideas how to contribute?

[advent_of_code_traits][crates-io] currently lacks support for **Error Handling** in the [trait definitions](src/lib.rs).

I'd greatly appreciate contributions of ideas and/or code here, it has me a bit stumped but I'm sure it can be done!

I'm very reluctant to release a 1.0 without big improvements here.

Issues labelled [good-first-issue]
are an excellent place to start.

Issues labelled [help-wanted] require extra attention from you, potential consumers of this library! They particularly welcome discussion, so throw in a suggestion or a comment. We want to hear your ideas. They welcome pull requests too of course, but I might keep the issue open to get feedback on your solution. Let's iterate :)

Here's an [example issue]

Once you find an issue you want to work on, comment on the issue to claim it, this lets me (and anyone else wanting to contribute) know that someone is working on it.

I think it would be cool for people to collaborate on issues, especially things that are more design/architecture orientated. So if an issue is claimed, feel free to comment still!

If you're struggling with an issue that you've claimed,
don't worry about it.
You can comment to say something like:
> "hmm, this is harder than I thought. If someone else wants to take a shot, be my guest"

You are always welcome ask a question and hopefully someone will have an idea that helps.

[example issue]: https://github.com/drmason13/advent_of_code_traits/issues/3
[help-wanted]: https://github.com/drmason13/advent_of_code_traits/issues?q=is%3Aissue+is%3Aopen+label%3A%22help+wanted%22
[good-first-issue]: https://github.com/drmason13/advent_of_code_traits/issues?q=is%3Aissue+is%3Aopen+label%3A%22good+first+issue%22

[crates-io]: https://crates.io/crates/advent_of_code_traits
