# Architecture

This document describes the high-level architecture of advent_of_code_traits. If you want to familiarize yourself with the code base, you are just in the right place!

This crate uses const generics to `impl Solution<Day>` where `Day` is a `u32`.

For readability and convenience, consts Day1..=25 are exported, as well as consts for Part1, Part2.
These are generated by [`build.rs`](build.rs) so you won't actually see them defined in src/. They are just `u32`s.

Currently this crate is very simple!

[`src/lib.rs`](src/lib.rs) contains:

* the traits:
  * `Solution<Day>` - One implementation per day.
  * `ParseInput<Day>` - One implementation per day.
  * `ParseEachInput<Day, Part>` - Two implementations per day: part1 and part2.
* the consts:
  * [`days::*`](src/days.rs) - Day1 to Day25
  * Part1, Part2

## The `ParseInput` and `ParseEachInput` traits

These traits are used to parse inputs to user-defined types before they run their solutions on them.

They both define the same associated type and method:

* `Parsed`
* `parse_method`

The user may implement `ParseInput`, and use the same input type for both parts of a day.

Or the user may decide they need a different type for each part.
In that case they will implement `ParseEachInput` for both `Part1` and `Part2`.

## The `Solution` trait

The `Solution` trait is the star of the show! Users will implement this trait with their solutions to Advent of Code.

It has two required methods:

* `part1` - the user's solution to part1.
* `part2` - the user's solution to part2.

Both of these methods take the `Parsed` type associated with the `ParseEachInput` implementation for its part.

`Solution` is a supertrait of `ParseInput` so that we can use its implementation of `parse_input`.

The reasons we split parsing into two traits are:

* We have to specify a different associated type for each part so that the user isn't *forced* to use the same type for both Parts of a Day.
* We don't want to *force* the user to implement the same parsing method twice, once for each day.
* Having two traits gives the user the choice of which trait to implement - ParseInput for one type for both parts or ParseEachInput for a different type for each part.

When defining the Solution trait we *don't* get a choice of which trait to use, so *we* are forced to use the more specific trait: `ParseEachInput`.

To prevent the user being *forced* to define all three implementations, there is a blanket implementation of `ParseEachInput` for both `Part1` and `Part2` for types that implement `ParseInput`.

This would fall apart if AdventOfCode ever brings out a Part 3.
