//This module includes functionality translated from mode_s.c
use deku::prelude::*;

pub const CRC_TABLE: [u32; 256] = [
    0x0000_0000,
    0x00FF_F409,
    0x0000_1C1B,
    0x00FF_E812,
    0x0000_3836,
    0x00FF_CC3F,
    0x0000_242D,
    0x00FF_D024,
    0x0000_706C,
    0x00FF_8465,
    0x0000_6C77,
    0x00FF_987E,
    0x0000_485A,
    0x00FF_BC53,
    0x0000_5441,
    0x00FF_A048,
    0x0000_E0D8,
    0x00FF_14D1,
    0x0000_FCC3,
    0x00FF_08CA,
    0x0000_D8EE,
    0x00FF_2CE7,
    0x0000_C4F5,
    0x00FF_30FC,
    0x0000_90B4,
    0x00FF_64BD,
    0x0000_8CAF,
    0x00FF_78A6,
    0x0000_A882,
    0x00FF_5C8B,
    0x0000_B499,
    0x00FF_4090,
    0x0001_C1B0,
    0x00FE_35B9,
    0x0001_DDAB,
    0x00FE_29A2,
    0x0001_F986,
    0x00FE_0D8F,
    0x0001_E59D,
    0x00FE_1194,
    0x0001_B1DC,
    0x00FE_45D5,
    0x0001_ADC7,
    0x00FE_59CE,
    0x0001_89EA,
    0x00FE_7DE3,
    0x0001_95F1,
    0x00FE_61F8,
    0x0001_2168,
    0x00FE_D561,
    0x0001_3D73,
    0x00FE_C97A,
    0x0001_195E,
    0x00FE_ED57,
    0x0001_0545,
    0x00FE_F14C,
    0x0001_5104,
    0x00FE_A50D,
    0x0001_4D1F,
    0x00FE_B916,
    0x0001_6932,
    0x00FE_9D3B,
    0x0001_7529,
    0x00FE_8120,
    0x0003_8360,
    0x00FC_7769,
    0x0003_9F7B,
    0x00FC_6B72,
    0x0003_BB56,
    0x00FC_4F5F,
    0x0003_A74D,
    0x00FC_5344,
    0x0003_F30C,
    0x00FC_0705,
    0x0003_EF17,
    0x00FC_1B1E,
    0x0003_CB3A,
    0x00FC_3F33,
    0x0003_D721,
    0x00FC_2328,
    0x0003_63B8,
    0x00FC_97B1,
    0x0003_7FA3,
    0x00FC_8BAA,
    0x0003_5B8E,
    0x00FC_AF87,
    0x0003_4795,
    0x00FC_B39C,
    0x0003_13D4,
    0x00FC_E7DD,
    0x0003_0FCF,
    0x00FC_FBC6,
    0x0003_2BE2,
    0x00FC_DFEB,
    0x0003_37F9,
    0x00FC_C3F0,
    0x0002_42D0,
    0x00FD_B6D9,
    0x0002_5ECB,
    0x00FD_AAC2,
    0x0002_7AE6,
    0x00FD_8EEF,
    0x0002_66FD,
    0x00FD_92F4,
    0x0002_32BC,
    0x00FD_C6B5,
    0x0002_2EA7,
    0x00FD_DAAE,
    0x0002_0A8A,
    0x00FD_FE83,
    0x0002_1691,
    0x00FD_E298,
    0x0002_A208,
    0x00FD_5601,
    0x0002_BE13,
    0x00FD_4A1A,
    0x0002_9A3E,
    0x00FD_6E37,
    0x0002_8625,
    0x00FD_722C,
    0x0002_D264,
    0x00FD_266D,
    0x0002_CE7F,
    0x00FD_3A76,
    0x0002_EA52,
    0x00FD_1E5B,
    0x0002_F649,
    0x00FD_0240,
    0x0007_06C0,
    0x00F8_F2C9,
    0x0007_1ADB,
    0x00F8_EED2,
    0x0007_3EF6,
    0x00F8_CAFF,
    0x0007_22ED,
    0x00F8_D6E4,
    0x0007_76AC,
    0x00F8_82A5,
    0x0007_6AB7,
    0x00F8_9EBE,
    0x0007_4E9A,
    0x00F8_BA93,
    0x0007_5281,
    0x00F8_A688,
    0x0007_E618,
    0x00F8_1211,
    0x0007_FA03,
    0x00F8_0E0A,
    0x0007_DE2E,
    0x00F8_2A27,
    0x0007_C235,
    0x00F8_363C,
    0x0007_9674,
    0x00F8_627D,
    0x0007_8A6F,
    0x00F8_7E66,
    0x0007_AE42,
    0x00F8_5A4B,
    0x0007_B259,
    0x00F8_4650,
    0x0006_C770,
    0x00F9_3379,
    0x0006_DB6B,
    0x00F9_2F62,
    0x0006_FF46,
    0x00F9_0B4F,
    0x0006_E35D,
    0x00F9_1754,
    0x0006_B71C,
    0x00F9_4315,
    0x0006_AB07,
    0x00F9_5F0E,
    0x0006_8F2A,
    0x00F9_7B23,
    0x0006_9331,
    0x00F9_6738,
    0x0006_27A8,
    0x00F9_D3A1,
    0x0006_3BB3,
    0x00F9_CFBA,
    0x0006_1F9E,
    0x00F9_EB97,
    0x0006_0385,
    0x00F9_F78C,
    0x0006_57C4,
    0x00F9_A3CD,
    0x0006_4BDF,
    0x00F9_BFD6,
    0x0006_6FF2,
    0x00F9_9BFB,
    0x0006_73E9,
    0x00F9_87E0,
    0x0004_85A0,
    0x00FB_71A9,
    0x0004_99BB,
    0x00FB_6DB2,
    0x0004_BD96,
    0x00FB_499F,
    0x0004_A18D,
    0x00FB_5584,
    0x0004_F5CC,
    0x00FB_01C5,
    0x0004_E9D7,
    0x00FB_1DDE,
    0x0004_CDFA,
    0x00FB_39F3,
    0x0004_D1E1,
    0x00FB_25E8,
    0x0004_6578,
    0x00FB_9171,
    0x0004_7963,
    0x00FB_8D6A,
    0x0004_5D4E,
    0x00FB_A947,
    0x0004_4155,
    0x00FB_B55C,
    0x0004_1514,
    0x00FB_E11D,
    0x0004_090F,
    0x00FB_FD06,
    0x0004_2D22,
    0x00FB_D92B,
    0x0004_3139,
    0x00FB_C530,
    0x0005_4410,
    0x00FA_B019,
    0x0005_580B,
    0x00FA_AC02,
    0x0005_7C26,
    0x00FA_882F,
    0x0005_603D,
    0x00FA_9434,
    0x0005_347C,
    0x00FA_C075,
    0x0005_2867,
    0x00FA_DC6E,
    0x0005_0C4A,
    0x00FA_F843,
    0x0005_1051,
    0x00FA_E458,
    0x0005_A4C8,
    0x00FA_50C1,
    0x0005_B8D3,
    0x00FA_4CDA,
    0x0005_9CFE,
    0x00FA_68F7,
    0x0005_80E5,
    0x00FA_74EC,
    0x0005_D4A4,
    0x00FA_20AD,
    0x0005_C8BF,
    0x00FA_3CB6,
    0x0005_EC92,
    0x00FA_189B,
    0x0005_F089,
    0x00FA_0480,
];

pub const MODES_MAX_BITERRORS: usize = 2;

#[derive(Debug)]
struct ErrorInfo {
    syndrome: u32,
    errors: usize,
    bit: [i8; MODES_MAX_BITERRORS],
}

pub fn modes_checksum(message: &[u8], bits: usize) -> Result<u32, DekuError> {
    let mut rem: u32 = 0;
    let n = bits / 8;

    if (n < 3) || (message.len() < n) {
        return Err(DekuError::Incomplete(NeedSize::new(4)));
    }

    for i in 0..(n - 3) {
        rem =
            (rem << 8) ^ CRC_TABLE[(u32::from(message[i]) ^ ((rem & 0x00ff_0000) >> 16)) as usize];
        rem &= 0x00ff_ffff;
    }

    let xor_term: u32 = u32::from(message[n - 3]) << 16
        ^ u32::from(message[n - 2]) << 8
        ^ u32::from(message[n - 1]);

    rem ^= xor_term;

    Ok(rem)
}
