

# Adminix is an [à la django admin](https://docs.djangoproject.com/en/4.0/ref/contrib/admin/#) for [actix](https://actix.rs/) - [sqlx](https://github.com/launchbadge/sqlx)


## Getting started

see example/


## Strategy / Tradeoffs

Adminix is implemented with [procedural macros](https://doc.rust-lang.org/reference/procedural-macros.html). A compile type, it introspects the database and builds routes and handlers for the actix server. These handler are simple crud route implemented with SSR, using the [Maud](https://maud.lambda.xyz/) templating library. It use the sqlx query! macro to confirm at compilation time that the queries generated by the macro are compatible with the datase.

Pros : 
- Adminix is quite simple by itself : only hundreds lines of code
- Adminix is quite robust : compilation give lot of assurence of correct behavior
- It's really easy to add to existing actix / sqlx project where the database is the source of thruth

Cons :
- adminix is not an rest API so if you want a now classical back/front architecture, you are on your own
- some


## ⚠ Very very alpha

A lot of assumption where made :
- actix "3" and sqlx "4"
- Sqlite only
- Every table must have an INTEGER "id" primary key
- Foreign key only target "id"
Also, i'm not a proficient rust developper.

## ⚠ No embeded security

It's up to the application to ensure authentification. Use gards !

## Support / Roadmap

| | |
:---:| ---
|☑|Basic CRUD
|☑|sqlite
|☐|postgres
|☐|mysql ?
|☑|foreign key link
|☐|save nullable (option)
|☐|foreign key edit
|☑|reverse foreign key link
|☑|filter on back
|☑|smart table in front (sort, filter)
|☑|home page / template
|☐|pagination
|☐|image blob support (readonly)
|☐|multiple blob file type
|☐|testing (proc macro + async = 🤔)
|☐|support non id primary key ?
|☐|support non id foreign key target ?

## Help welcome !

Please, fill issues !
I'm also accepting merge requests, ping me if I'm not reactive enough : ( f"julienfr{ meaning_of_life + 70 }@gmail.com" )