// import crate for matrix math
extern crate nalgebra as na;

#[derive(Debug, Clone)]
pub struct Equatorial {
    pub ra: f64,
    pub dec: f64,
    pub fr: f64,
    pub rot: na::Rotation3<f64>,
}

impl Equatorial {
    pub fn calculate_rotation_matrix(&mut self){
        self.rot = na::Rotation3::from_euler_angles(self.fr, -self.dec, self.ra).inverse();
    }

    pub fn update_equatorial_coordinates(&mut self, vec: &[f64; 3]){
        self.fr  = vec[0];
        self.dec = vec[1];
        self.ra  = vec[2];

        self.calculate_rotation_matrix();
    }

    pub fn new() -> Equatorial {
        let ra = 0.0;
        let dec = 0.0;
        let fr = 0.0;
        let rot = na::Rotation3::<f64>::identity();
        let eq = Equatorial{
            ra,
            dec,
            fr,
            rot,
        };
        eq
    }

}