use std::hash::{Hash, Hasher};

/// This is just an identification number.
/// Usually, it will be generated by `#[derive(Nametag)]` at compile time.
pub type Tag = u128;

/// The core element in registering shaders for use in the program.
/// Applying `#[derive(Nametag)]` to an enum with variants will let you use those enums
/// as identifiers for shaders in your pipeline.
pub trait Nametag {
    fn tag(self) -> Tag;
}

impl Nametag for Tag {
    fn tag(self) -> Tag {
        self
    }
}

impl<'a> Nametag for &'a str {
    fn tag(self) -> Tag {
        let mut hasher = std::collections::hash_map::DefaultHasher::new();
        self.hash(&mut hasher);
        hasher.finish() as Tag
    }
}
