use near_sdk::{env, AccountId};

pub trait AccessControl {
    fn add_role(&mut self, role: &String);

    fn has_role(&self, role: &String, account: &AccountId) -> bool;

    fn check_role(&self, role: &String, account: &AccountId);

    fn assert_role(&self, role: &String);

    fn assert_self(&mut self);

    fn get_role_admin(&self, role: &String) -> String;

    fn get_account_roles(&self, account: &AccountId) -> Vec<String>;

    fn grant_role(&mut self, role: &String, account: &AccountId);

    fn setup_account_role(&mut self, role: &String, account: &AccountId);

    fn delete_role_member(&mut self, role: &String, account: &AccountId);

    fn revoke_role(&mut self, role: &String, account: &AccountId);

    fn set_admin_role(&mut self, role: &String, admin_role: &String);

    fn add_role_member(&mut self, role: &String, account: &AccountId);
}
