# abridge

Compress a sorted word list or decompress a file compressed by abridge or GNU word-list-compress.

`abridge` is a port of GNU [word-list-compress](https://duckduckgo.com/?q=word-list-compress) to Rust.

`word-list-compress` is about 150 SLOC. `abridge` is about 50 SLOC or 80 with the CLI. They perform identically.

## Install

You'll need the Rust compiler and Cargo. The easiest way to do that is to get [rustup](https://rustup.rs/).

```shell
cargo install abridge
```

## Usage

See `abridge --help`.

## Examples

```shell
abridge -c < words.txt # compress words.txt
```

```shell
abridge --decompress < words.tzip # decompress words.tzip
```

```shell
abridge --compress < words.txt > words.tzip # compress words.txt and save to file
```

## Safety 

Abridge can *compress* word lists where:

- Words are in alphabetical order
- Words are separated by newline
- Words contain ASCII characters 

Words may include uppercase characters, but use lowercase for the best results.

Abridge can *decompress* files compressed by `abridge` or `word-list-compress` alike.

## Testing

Run `cargo test`.

## License

Abridge is licensed under [GNU General Public License](https://www.gnu.org/licenses/gpl-3.0.en.html). 

