# Examples

Run the `cargo run --example <file_name>` to see how each example works.

- `custom_protocol`: uses a custom protocol to load files from bytes.
- `custom_titlebar`: A frameless window with custom title-bar to show `drag-region` class in action.
- `detect_js_ecma`: detects which versions of ECMAScript is supported by the webview.
- `dragndrop`: example for file drop handler.
- `form_post`: submit form POST and get data in rust without any web server.
- `fullscreen`: full screen example demonstrates how to configure the window with attributes.
- `hello_world`: the basic example to show the types and methods to create an application.
- `menu_bar`: uses a custom menu for the application in macOS and the Window and Linux/Windows.
- `multi_window`: create the window dynamically even after the application is running.
- `stream_range`: read the incoming header from the custom protocol and return part of the data. [RFC7233](https://httpwg.org/specs/rfc7233.html#header.range)
- `system_tray_no_menu`: open window on tray icon left click.
- `system_tray`: sample tray application with different behaviours.
- `transparent`: transparent example that also show how to create a valid data URI.
