# SKEAZN642

[![docs.rs](https://docs.rs/SKEAZN642/badge.svg)](https://docs.rs/SKEAZN642)
[![crates.io](https://img.shields.io/crates/v/SKEAZN642.svg)](https://crates.io/crates/SKEAZN642)
[![crates.io](https://img.shields.io/crates/d/SKEAZN642.svg)](https://crates.io/crates/SKEAZN642)

Rust Peripheral Access Crate (PAC) for the NXP Kinetis KEA64 subfamily of automotive microcontrollers.
  * S9KEAZN16AMLC
  * S9KEAZN32AMLC
  * S9KEAZN64AMLC
  * S9KEAZN16AMLH
  * S9KEAZN32AMLH
  * S9KEAZN64AMLH

This crate was generated by [svd2rust](https://github.com/rust-embedded/svd2rust) with some manual additions as needed.

SVD obtained from [ARM CMSIS Device Packs](https://developer.arm.com/embedded/cmsis/cmsis-packs/devices/NXP/SKEAZ64xxx4).

## memory.x

An example memory.x is provided for the S9KEAZN32AMLH (32K Flash, 4K RAM, 256b EEPROM).

To use in your project, rename memory-32.x to memory.x and adjust as needed.
Note that there are protected configuration values (Section .FlashConfig)
from 0x400 up to 0x410.
The text section begins at 0x410.

## EEPROM

EEPROM (Section .eeprom) begins at 0x1000_0000.
There appears to be no way to program the eeprom directly with development tools.

The work around is to detect if the eeprom is empty/invalid and write to it during
setup/initialization. This is not a deficiency in rust or this crate.

## License

Excluding the source SVD and any licenses that may apply to the generated code,
all files in this project are licensed under the MIT license.
