use pcap::{Capture, Device};
use pktparse;
use clap::{Arg, App, SubCommand};

fn main() { 


    let application = App::new("PacketDog")
        .version("0.0.1")
        .author("ibx34#6030 (366649052357591044)")
        .about("Track packets in/out bound on your device")
        // .arg(Arg::with_name("run")
        //     .short("r")
        //     .long("run")
        //     .takes_value(false)
        //     .help("Runs PacketDog")
        // ).get_matches();
        .subcommand(
            SubCommand::with_name("run")
            .about("Runs PacketDog (provide no args/options for default logging)")
            .arg(Arg::with_name("list-devices")
                .short("l")
                .long("list")
                .takes_value(false)
                .help("Only lists devices.")
            )
        ).get_matches();
    

    if let Some(_matches) = application.subcommand_matches("run") {
        
        let mut main_device: Device = Device::lookup().unwrap();
        let devices = Device::list().unwrap();
        
        if _matches.is_present("list-devices") {
            println!("Listing all devices.");
            for device in &devices {
                println!("Name: {}\nDescription: {}\n-------",
                    device.name,
                    device.desc.clone().unwrap_or("No description".to_string())
                )
            }

            return;
        }

        let device = devices.get(3).unwrap();
        main_device.name = device.name.clone();
        main_device.desc = device.desc.clone();

        let mut cap = Capture::from_device(
            main_device
        ).unwrap().open().unwrap();
        
        while let Ok(packet) = cap.next() {
            
            match pktparse::udp::parse_udp_header(packet.data) {
                Err(error) => {
                    println!("Error while handling UDP... {}", error)
                }            
                Ok(udp) => {
                    println!("{:?}", udp.1);
            
                    match pktparse::tcp::parse_tcp_header(udp.0) {
                        Err(error) => {
                            println!("Error while handling TCP... {}", error)
                        }   
                        Ok(tcp) => {
                            println!("{:?}", tcp.1);
                                    
                            match pktparse::ipv6::parse_ipv6_header(tcp.0) {
                                Err(error) => {
                                    println!("Error while handling IPV6... {}", error)
                                }
                                Ok(success) => {
                                    println!("{:?}", success.1);
                    
                                    match pktparse::ipv4::parse_ipv4_header(success.0) {
                                        Err(error) => {
                                            println!("Error while handling IPV4... {}", error)
                                        }
                                        Ok(success) => {
                                            println!("{:?}", success.1);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}