# Nuclide
 
 This is a nuclide database meant to address two issues. The lack of any nuclide databases in Rust, and the generally limited
 and outdated information other databases have (frequently copying data from Wikipedia or T. Gray's periodic table, which are outdated in there own right). The current version of this library has data on 3585 nuclides in their ground-base states. The primary sources are NUBASE2020[9], the ENDSF[10], and various Nuclear Data Sheets.
  In cases of ambiguity, estimates are made by the author based on trends from the neighboring nuclides. 
  
                                                                  -Sory, J.A
#### Available Data
- Electronegative Values predicted for the thermochemical
 electronegativity, currently the best predictor of experimental values[1].
- Pauling  Electronegativity using the Pauling scale, mostly kept for completeness as
the Pauling scale performs poorly in application [3].
- Allen Electronegativity using the Allen scale[2]
- Electron Affinities of the elements, in kilojoules/mol
- Ionization Energies of all known electron configurations[8]
- Covalent Radii The covalent radii calculated from single[5], double[6] and triple[7] bonds
- Van der Waal radii approximated in crystalline structures and isolated atoms. 
Unlike most libraries and databases which use Bondi’s approximations to the van der Waal
radius, Batsanov’s approximations are used here [4].
- Half-life, mean lifetime and decay constant for each nuclide.
- Atomic mass, binding energy and mass defect for each nuclide.

#### Features                                        
In addition to providing the previous information this library has some other features. 
- Simple modeling of decay including decay particle energies
- Prediction of mass and binding energies of theorectical nuclides using Bethe-Weiszacker Liquid Drop model
See the [Periodic-Table repository](https://github.com/JASory/Periodic-Table) for a simple look-up gui implementation. 

#### Usage 
   ```rust

 use Nuclide::Nuclide;
 
   // Create mutable U-235 nuclide, mutable to permit decay. 
   
  let mut u238 = Nuclide::new(U-238).unwrap();
  
  // Atomic mass in Daltons
  
  assert_eq!(u238.am(),238.050786936);
  
   // Approximation ionization energy of U-238 +52 in kilojoules per mole 
   
   //(SI units are prioritized, however non-SI units are also frequently supported)
   
   assert_eq!(u238.ionization_energies(52).unwrap(),283474.03313085996);
   
   // Model the decay over 5x10^20 seconds, total energy and particles are released 
   
   let (decay_energy, decay_particles) = u238.decay(5E+20);
   
   assert_eq!(u238.identity(), "Pb-206")
 ```
#### References
[1] Tantardini, C., Oganov, A.R. ”Thermochemical Electronegatives of the elements”. Nature Commu-
nications 12, 2087 (2021).doi:10.1038/s41467-021-22429-0

[2] Allen, L.C. ”Electronegativity is the average one-electron energy of the valence-shell electrons in
ground-state free atoms”. Journal of the American Chemical Society. 111(25),1989. pp. 9003-9014.
doi:10.1021/ja00207a003

[3] Lynne Reed Murphy, Terry L. Meek, A. Louis Allred, and Leland C. Allen. ”Evaluation and Test
of Pauling’s Electronegativity Scale”. The Journal of Physical Chemistry. vol. 104 (24), 2000. pp.
5867-5871 doi:10.1021/jp000288e

[4] Batsanov, S.S. ”Van der Waals Radii of Elements”.Inorganic Materials Vol 37, 2001. pp. 871-
885.doi:10.1023/A:1011625728803

[5] Pyykkö, P., Atsumi, M. (2009). Molecular Single-Bond Covalent Radii for Elements 1-118. Chemistry
 A European Journal, 15(1), 186–197. doi:10.1002/chem.200800987
 
[6] Pyykkö, P., Atsumi, M. (2009). Molecular Double-Bond Covalent Radii for Elements Li–E112. Chem-
istry - A European Journal, 15(46), 12770–12779. doi:10.1002/chem.200901472

[7] Pyykkö, P., Riedel, S., Patzschke, M. (2005). Triple-Bond Covalent Radii. Chemistry - A European
Journal, 11(12), 3511–3520. doi:10.1002/chem.20040129

[8] Kramida, A., Ralchenko, Yu., Reader, J., and NIST ASD Team (2020). NIST Atomic Spectra Database (ver. 5.8), [Online]. Available: https://physics.nist.gov/asd [2021, September 17]. National Institute of Standards and Technology, Gaithersburg, MD. DOI: https://doi.org/10.18434/T4W30F

[9] Kondev, F.G et al. ”The NUBASE2020 evaluation of nuclear physics properties”. 2021 Chinese Phys.
C45 030001

[10] Brookhaven National Laboratory. https://www.nndc.bnl.gov/ensdf/. Accessed Jul 16 2021.
