// Used to write and update the data arrays. 
use crate::index::SYMBOL;
use crate::index::SYMBOL_INDEX;


//Formatting for f64
 fn formatstyle_f64(x: f64, index_length: usize)->String{

       let mut k = String::new();
              if x.is_nan() {
                k = "f64::NAN".to_string();
              }
             else if !x.is_finite(){
               k= "f64::INFINITY".to_string();
             }
            else if x == 0f64{
              k="0f64".to_string();
             }
            else{
             k=x.to_string()+"f64";
            }
            
           (0..(index_length-k.len())).map(|_|" ").collect::<String>() + &k + " , "

      }
      
   fn   formatstyle_u64(x: &u64)-> String{
        let mut k = String::new();
        
         k = x.to_string();
         (0..(20-k.len())).map(|_|" ").collect::<String>() + &k + " , "
         }
         
      //Formatting for u8 tuple
 fn stringstyle()->String{

        "(0u8, 99u8, 99u8) , ".to_string()

}

// opens and writes file
 fn note(x:&str,y:&str){
   use std::fs::File;
   use std::io::Write;
   
  let mut file = File::create(y).expect("Whoopsie, ran out of paper . . .");

   println!("Wrote to {} in the local directory",y );
   file.write_all(x.as_bytes()).expect("Whoopsie ran out of ink . . .");
}
/*
   Formatting styles tablename: (index length, column count) 
   HALF_LIFE : (35,4), ATOMIC_MASS : (17,5), (50,3) for Kilogram Elemental arrays of length 118: (7;6)


*/


 pub fn table_string_f64(data: Vec<f64>, index_length: usize, col_count: usize, name: &str)-> String{
  let mut t = data.iter().map(|x| formatstyle_f64(*x,index_length)).collect::<Vec<String>>();
       
   for i in 0..t.len(){
       if i%col_count == col_count-1{
        t[i]+="\n  "
       }
   }
  let k = t.iter().map(|x| x.clone()).collect::<String>();
  "pub const ".to_owned() + name +" : [f64;" + &data.len().to_string() + "] =    [ \n \n  " + &k + "\n \n ];"   
 }
 //
 pub fn table_string_u64(data: Vec<u64>, col_count: usize, name: &str)->String{
 
 let mut t = data.iter().map(|x| formatstyle_u64(x)).collect::<Vec<String>>();
 for i in 0..t.len(){
       if i%col_count == col_count-1{
        t[i]+="\n  "
       }
   }
  let k = t.iter().map(|x| x.clone()).collect::<String>();
  "pub const ".to_owned() + name +" : [u64;" + &data.len().to_string() + "] =    [ \n \n  " + &k + "\n \n ];"   
 
 }

  //prints data vector with spaces of index_length and columns = col_count, some useful ones are Half-Life = 35, 4 and atomic mass 15,5 
pub  fn table_print_f64(data: Vec<f64>, index_length: usize,col_count: usize, name: &str, output: &str){
 let table = table_string_f64(data, index_length, col_count, name);
  
 note(&table,output)
}

pub fn table_print_u64(data: Vec<u64>, col_count: usize, name: &str, output: &str){
      let table = table_string_u64(data, col_count, name);
      note(&table, output)
  }


// changes the value at the index for a vector x
 fn update(x: &mut[f64],value:f64 , index: usize){

    x[index]=value

   }

//changes the value for all in x between index and the length of the updating vector, a superior version of update
pub fn update_vector(x: &mut[f64], value: &[f64],index:usize){
let start_slice =  &mut x[index..(value.len()+index)];

for (i,j) in start_slice.iter_mut().zip(value.iter()){

*i=*j;
}
}

pub fn update_vector_u64(x : &mut[u64], value: &[u64], index: usize){
let start_slice =  &mut x[index..(value.len()+index)];

for (i,j) in start_slice.iter_mut().zip(value.iter()){

*i=*j;
}
}


//Finds the nuclide index to start from, this is identical to Nuclide::new

fn bounds_check(x: &str, isotope:usize)->Result<usize, String>{

  match SYMBOL.iter().position(|y| y ==&x){
        Some(x)=> if isotope >= SYMBOL_INDEX[x].1 &&  isotope <= SYMBOL_INDEX[x].2 {
                     return Ok(SYMBOL_INDEX[x].0+isotope-SYMBOL_INDEX[x].1)
                   }
                   else{
                   return Err("Not a known isotope".to_string())
                   }
       None=> return Err("Not a known element".to_string())
       }
}
