# Nuclide
 Sory, J.A

Objectives This Library was made with several design goals in mind. 
- Provide up-to-date data on all known nuclides. Currently supports 3299 nuclides, will be expanded to 3565 nuclides to include all values from the NUBASE2020 and ENDSF database. Many of the missing nuclides are not confirmed to exist
- Extensibility. It must be able to support expansions for accuracy and increased capability. 
- Updatability. It must be easy to edit, change and expand information.

As a consequence of these goals nuclide.rs is designed as a series of data arrays and accessed by a single value struct. The data arrays in turn are modifiable using builtin functions.

### Structure  
The structure of Nuclide can be split up in data arrays
- Electronegative Values predicted for the thermochemical electronega-
tivity, currently the best predictor of experimental values[1].
- Pauling  Electronegativity using the Pauling scale, mostly kept for completeness as
the Pauling scale performs poorly in application [3].
- Allen Electronegativity using the Allen scale
- Electron Affinity The Electron Affinities of the elements, in kilojoules/mol
- Ionization Energies Ionization energies of the first 3 electrons in kilojoules/mol
- Covalent Radii The covalent radii calculated from single[5], double[6] and triple[7] bonds, stored
in a 1 1 , 1 2 , 1 3 , 2 1 . . . pattern.
- Van der Waal Crystal The van der waal radius approximated in crystalline structures.
Unlike most libraries and databases which use Bondi’s approximations to the van der Waal
radius, Batsanov’s approximations are used here [4].
- Van der Waal Isolated The van der waal radius approximated for isolated atoms[4].

Nuclide. All data is taken from NUBASE2020 [8] and the IAEA’s ENSDF [9] in cases of ambiguity.
– Atomic Mass Atomic Mass of the nuclides, in daltons. Currently uses Wikipedia's data being updated to NUBASE2020
– Half Life Average half-life of the nuclides, in seconds. Being updated to NUBASE2020
– Decay Chain By far the largest {263920 bytes} and most complex dataset to implement.
Each nuclide is represented by a slice of 10 u64. The first 5 values are the decay probabilities
for each potential chain in the nuclide’s decay and the last. The use of large u64 values allow
for highly accurate randomness, permitting steps of ≈ 5.42E − 20{1/2 64 − 1} equivalent to
≈ 120 atoms per mole. Additionally using a u64 allows directly comparing hardware RNG
64bits removing any loss of entropy caused by restricting intervals or other modifications. The
last 5 are utilized by the curry decay function to model the decays.


#### References
[1] Tantardini, C., Oganov, A.R. ”Thermochemical Electronegatives of the elements”. Nature Commu-
nications 12, 2087 (2021).doi:10.1038/s41467-021-22429-0

[2] Allen, L.C. ”Electronegativity is the average one-electron energy of the valence-shell electrons in
ground-state free atoms”. Journal of the American Chemical Society. 111(25),1989. pp. 9003-9014.
doi:10.1021/ja00207a003

[3] Lynne Reed Murphy, Terry L. Meek, A. Louis Allred, and Leland C. Allen. ”Evaluation and Test
of Pauling’s Electronegativity Scale”. The Journal of Physical Chemistry. vol. 104 (24), 2000. pp.
5867-5871 doi:10.1021/jp000288e

[4] Batsanov, S.S. ”Van der Waals Radii of Elements”.Inorganic Materials Vol 37, 2001. pp. 871-
885.doi:10.1023/A:1011625728803

[5] Pyykkö, P., Atsumi, M. (2009). Molecular Single-Bond Covalent Radii for Elements 1-118. Chemistry
 A European Journal, 15(1), 186–197. doi:10.1002/chem.200800987
 
[6] Pyykkö, P., Atsumi, M. (2009). Molecular Double-Bond Covalent Radii for Elements Li–E112. Chem-
istry - A European Journal, 15(46), 12770–12779. doi:10.1002/chem.200901472

[7] Pyykkö, P., Riedel, S., Patzschke, M. (2005). Triple-Bond Covalent Radii. Chemistry - A European
Journal, 11(12), 3511–3520. doi:10.1002/chem.20040129

[8] Kondev, F.G et al. ”The NUBASE2020 evaluation of nuclear physics properties”. 2021 Chinese Phys.
C45 030001

[9] Brookhaven National Laboratory. https://www.nndc.bnl.gov/ensdf/. Accessed Jul 16 2021.
