# Contributing to NtHiM

We welcome Pull Requeusts from **NtHiM** users, developers and anyone who is interested to help in upgrading the status of the project. This guide will include the guidelines you will need to follow while contributing.

When contributing to **NtHiM**, please first make sure to discuss the change you wish for by opening up a new issue, sending an e-mail, or any other method of communication with the existing authors of this repository before making a change.

Also, please note that we have a [Contributor Covenant Code of Conduct](CODE_OF_CONDUCT.md), so please follow it during all of your interactions with this repository or the project as a whole.

***

## Pull Request Guidelines

1. Make sure any install or build dependenices are removed before the end of the layer when doing a build.
2. Update the README.md with the details of changes to the interface, and make sure to include all of the important information such as nenw environment variables, useful file locations and other parameters.
3. _(Optional)_ Increase the version numbers in any examples files and the README.md to the new version that your Pull Request would represent. The versioning scheme we use is available in the [Versioning](#versioning) section below.

***

## Versioning

We follow our own unique versioning schema for **NtHiM**.

1. **MAJOR**: `0.*.0` (_`v0.*.0`_)
2. **MINOR**: `0.0.*` (_`v0.0.*`_)

### Examples

1. For the second major release, the version number would be **0.2.0**.
2. For the first minor release under the second major release, the version number would be **0.2.1** (_not 0.0.1_).

***

## Code of Conduct

Our Code of Conduct is available at [CODE_OF_CONDUCT.md](CODE_OF_CONDUCT.md).
