# Strings
Collection of bytes, with methods to interpret them as text.

`str` is th string slice of a part of the programs binary data.
`String` type is a growable UTF-8 string type.
There are other types (`OsString`, `OsStr`, `CString`, `Cstr`), as well as other crates providing that functionality. 

## New String
`let mut s = String::new();`
Now we can add things to the string.

```rust
let data = "initial contents"
let s = data.to_string(); // Available on types that implement `Display` trait
let s = "initial contents".to_string(); // Same but avoid 1 stack allocation
let s = String::from("initial contents"); // Creat from any string, which does not care about language and characters, it encodes to UTF-8
```

## Updating a String
```rust
let mut s = String::from("foo");

// Append
s.push_str("bar");
s.push_str(s1); // Append another string, which adds the string slice, does not take ownership
s.push('a'); // Append a single character
```

```rust
// Concatenation
let s2 = s1 + &s;

```
 - s1 is invalidated as it is moved from s1 to s2
 - &s requires `&` because of the `+` operator (in-depth later)
 - + adds 2 `str`, so `&s` becomes `&s[..]` which dereferences it into a string slice (Chapter 15), wihtout taking into ownership
Using the `+` operator produces a bit of unclear behaviour, takes ownership of 1st var and gets a reference an copies into the 1st var, then returns ownership of that together.

We can use formatting to a better effect with strings:
```rust
// Concatenation with formatting
let s = format!("{}-{}-{}", "tic", "tac", "toe");
```

## Indexing in a String - Internal Representaion and How "characters" are encoded
We can't use `[]` in a `String` type, like in string slices.
Although internally it is a `Vec<u8>`, but a character may occupy more than 8bits, like in the cyrillic alphabet!

A `String` holds charaters, Scalar Values and Grapheme Clusters, a string that may appear to have 13 "letters" may well have a length double that, as those "letters" are actual characters that require multiple values to be described.

Then how do we get characters -> for with automatic slicing
```rust
for c in "नमस्ते".chars() {
    println!("{}", c); // Prints each character in succession
}
```

This works well for constant byte agroupations but is not a correct way of handling all strings. Not provided in the standard library but there are `crates` available.

**So, Strings are not simple**
