fn main() {
    enums_ip();
    if_let_match();
}

enum IpAddrKind{
    V4(String),
    V6(String)
}

struct IpAddr {
    kind: IpAddrKind,
    address: String,
}

impl IpAddrKind {
    fn call(){}
    fn callself(&self){}
}

fn enums_ip () {
    let home_ipv4 = IpAddrKind::V4(String::from("127.0.0.1"));
    let loopback_ipv6 = IpAddrKind::V6(String::from("::1"));

    home_ipv4.callself();
    IpAddrKind::call();
}

fn if_let_match()
{
    let config_max = Some(3u8);
    let config_invalid: Option<u8> = None; // have to define Option<Type> if none

    if let Some(max) = config_max{
        println!("{}", max);
    };

    if let Some(max) = config_invalid {
        println!("this will not work");
    } else if let Some(max) = config_max{
        println!("last was invalid, this is good {}", max);
    };
}