# Enums
Non Algebraic, data type to differentiates different types in a category.
Ex:
```rust
enum IpAddressKind{
    V4,
    V6
}
// There are 2 IP Adrress types, IPv4 IPv6, but both are IP Addresses

let four = IpAddressKind::V4;
let six = IpAddressKind::V6;
// Access through namespace
```

## Attached types

To take care of type and value, we would make a struct:
```rust
// Ew, so long, type attached enums rock
struct IpAddr {
    kind: IpAddrKind,
    address: String,
}

let home = IpAddr {
    kind: IpAddrKind::V4,
    address: String::from("127.0.0.1"),
};

let loopback = IpAddr {
    kind: IpAddrKind::V6,
    address: String::from("::1"),
};
```

But Enum values can have attached data types:
```rust
enum IpAddrKind{
    V4(String),
    V6(String)
}

let home_ipv4 = IpAddrKind::V4(String::from("127.0.0.1"));
let loopback_ipv6 = IpAddrKind::V6(String::from("::1"));
```
Which is way more concise than having to declare for example a struct to take care of which type of address an ip has.

Thus making this enum values like `shorthand` structs, but not quite.
When we create such value, each variant of the enum can have different types attached
```rust
enum IpAddrKind {
    V4(u8,u8,u8,u8),
    V6(String)
}
```
In this case, the standard library already defines this `IpAddr` enum with the structs attached `Ipv4Addr` and `Ipv6Addr` to each one.

## Methods
Enums can also have methos and functions!
```rust
impl IpAddr {
    fn call(&self){}
    fn wait() {}
}
```
--- 

# Option Enum
```rust
enum Option<T> {
    None,
    Some(T)
}
```
Basically, option can either hold a value of any type or not hold anything, but still depending on the type.
Super Important, is like checking for `NULL` or `nullptr`.
`<T>` stands for generics, that it can be of any type.
```rust
let some_number = Some(5); // Option Enum that has Some with value 5
let some_string = Some("a string"); // Option Enum that has Some with string "a string"

let absent_number: Option<i32> = None; // Option Enum of type i32 that has no value (None)

// but!
let x: i8 = 5; // Type i8 Value of 5
let y: Option<i8> = Some(5); // Option of type i8, with Some of value 5
let sum = x+y; // Error, we can't use Some to actually do something
```
To access the value encoded in the enum, we need to convert it to the type we want!

How do you do that? With a method implemented for the enum.