fn main() {
    struct_creation();
    tuple_structs();
    rectangle_example();

    methods1();
    methods2();
}

struct User {
    active: bool,
    username: String,
    email: String,
    sign_in_count: u64,
}

fn struct_creation()
{
    let email = String::from("someone@example.com");
    let var = build_user(email, String::from("Marc"));
    // email is now invalid as it has been moved to var
    println!("{}", var.email);

    let user1 = User {
        active: true,
        username: String::from("Marc"),
        email: var.email,
        sign_in_count: 2,
    };
    // Now var.email is invalid
    // println!("{}", var.email);
    
    // This one uses Struct Update Syntax, it moves ownership of the fields to user2
     let user2 = User {
        email: String::from("another@example.com"),
        ..user1 // ..other var to just grab the same fields from the other var
    };
    // Here, email is not moved from user1 to user2, but username is
    // user1. username will be invalid as it is moved
    //println!("{} {}", user1.username, user2.username);
}

fn build_user(email: String, username: String) -> User {
    User {
        email,
        username,
        active: true,
        sign_in_count: 1,
    }
}

struct ColorRBGA(i32, i32, i32, i32);
fn tuple_structs() {
    struct ColorRGB(i32, i32, i32);
    struct Point(i32, i32, i32);
    
    let black = ColorRGB(0,0,0);
    // println!("{}", black.1);
    let origin = Point(0,0,0);
    
    // black is not the same type of origin, but they have the same exact fields
}

#[derive(Debug)]
struct Rectangle {
    width: u32,
    height: u32,
}

fn rectangle_example() {
    let rect1 = Rectangle {
        width: 30,
        height: 50,
    };

    println!(
        "The area of the rectangle is {} square pixels.",
        area(&rect1)
    );

    println!("{:?}", rect1);
}

fn area(rectangle: &Rectangle) -> u32 {
    rectangle.width * rectangle.height
}

//===

#[derive(Debug)]
struct Rect {
    width: u32,
    height: u32,
}

impl Rectangle {
    fn area(&self) -> u32 {
        self.width * self.height
    }
    // Methods 2
    fn can_hold(&self, cmp: &Rectangle) -> bool {
        (self.width > cmp.width && self.height > cmp.width) 
        || (self.width > cmp.height && self.height > cmp.width)
    }
    // Associated Function
    fn square(size: u32) -> Rectangle {
        Rectangle {
            width: size,
            height: size
        }
    }
}

fn methods1() {
    let rect1 = Rectangle {
        width: 30,
        height: 50,
    };

    println!(
        "The area of the rectangle is {} square pixels.",
        rect1.area()
    );
}

fn methods2() {
    let rect1 = Rectangle {
        width: 30,
        height: 50,
    };
    let rect2 = Rectangle {
        width: 10,
        height: 40,
    };
    let rect3 = Rectangle {
        width: 60,
        height: 45,
    };

    println!("Can rect1 hold rect2? {}", rect1.can_hold(&rect2));
    println!("Can rect1 hold rect3? {}", rect1.can_hold(&rect3));
    
    // Associated function call
    let sq1 = Rectangle::square(20);
    println!("Square is {:?}", sq1);
}