use std::io;

const THREE_HOURS_IN_SECONDS: u32 = 60 * 60 * 3;

fn main() {
    mutability();
    shadowing_vars();
    operations();
    compound_types();
    print_labeled_measurement(23, 'A');
    if_else_test();
    loopnaming();
    loop_result();
}

fn mutability() {
    let mut x = 5;
    println!("The value of x is: {}", x);
    x = 6;
    println!("The value of x is: {}", x);
}

fn shadowing_vars() {
    let x = 5;

    let x = x + 1;

    {
        let x = x * 2;
        println!("The value of x in the inner scope is: {}", x);
    }

    println!("The value of x is: {}", x);
}

fn operations() {
  // addition
  let sum = 5 + 10;

  // subtraction
  let difference = 95.5 - 4.3;

  // multiplication
  let product = 4 * 30;

  // division
  let quotient = 56.7 / 32.2;
  let floored = 2 / 3; // Results in 0

  // remainder
  let remainder = 43 % 5;
}

fn compound_types() {
    let tup: (i32, f64, u8) = (500, 6.4, 1);
    let (x,y,z) = tup;

    let a = [1, 2, 3, 4, 5];
    println!("{}",a[0]);
    let a: [i32;1] = [1];
    let mut index = String::new();
    println!("Set index to access arr:");
    io::stdin()
        .read_line(&mut index)
        .expect("Failed to read line");

    let index: usize = index
        .trim()
        .parse()
        .expect("Index entered was not a number");

    println!("{}",a[index]);
}

fn print_labeled_measurement(value: i32, unit_label: char) {
    println!("The measurement is: {}{}", value, unit_label);
    println!("Print five function return: {}", five());
}

fn five() -> i32 {
    5
}

fn if_else_test() {
    let number = 3;
    if (number < 5) {
        println!("contition was true");
    } else 
    if (true) && false {
        println!("condition was false");
    } else
    if(true) {} else if(true){};
}

fn loopnaming() {
    let mut count = 0;
    'counting_up: loop {
        println!("count = {}", count);
        let mut remaining = 10;

        loop {
            println!("remaining = {}", remaining);
            if remaining == 9 {
                break;
            }
            if count == 2 {
                break 'counting_up;
            }
            remaining -= 1;
        }

        count += 1;
    }
    println!("End count = {}", count);
}

fn loop_result() {
    let mut counter = 0;

    let result = 'loop1: loop {
        counter += 1;
        loop {
            counter += 1;
            if(counter == 10) {
                break 'loop1 {counter * 2};
            }
        }
        if counter == 10 {
            break counter * 2;
        }
    };

    println!("The result is {}", result);
}