use std::io;

fn main() {
    println!("Transform Fahrenheit to Celsius:");
    let mut input = String::new();
    let parsed: f32 = loop {
        io::stdin()
            .read_line(&mut input)
            .expect("Fail!");
            
        match input.trim().parse() {
            Ok(num) => {break num},
            Err(_) => {
                println!("Write Number!");
                continue;
            }
        };
    };
    println!("{} F is {} C", parsed, fahrenheit_to_celsius(parsed));

    println!("Get the fibonacci number:");
    input = String::new();

    let parsed: i64 = loop {
        io::stdin()
            .read_line(&mut input)
            .expect("Fail!");
            
        match input.trim().parse() {
            Ok(num) => {break num},
            Err(_) => {
                println!("Write Integer Number!");
                continue;
            }
        };
    };
    println!("Fibonacci of {} is {}", parsed, fibonacci(parsed));

    twelve_days_of_christmas();
}

fn fahrenheit_to_celsius(temp:f32) -> f32 {
    (temp - 32.) * (5./9.)
}

fn fibonacci(iter:i64) -> i64 {
    if iter == 1 {return 1;};
    if iter == 0 {return 0;};
    fibonacci(iter - 1) + fibonacci(iter - 2)
}

const FIRST_LYRIC: &str = "On the first day of Christmas\nMy true love sent to me";

fn twelve_days_of_christmas() {
    let start = "On the first day of Christmas
    My true love sent to me";
    let days_gifts = [
        "12 drummers drumming",
        "Eleven pipers piping",
        "Ten lords a-leaping",
        "Nine ladies dancing",
        "Eight maids a-milking",
        "Seven swans a-swimming",
        "Six geese a-laying",
        "Five golden rings (five golden rings)",
        "Four calling birds",
        "Three French hens",
        "Two turtle-doves",
        "a partridge in a pear tree"
    ];

    let size = days_gifts.len();
    for number in (0..size) {
        println!("On the day {} of Christmas\nMy true love sent to me", number+1);
        let step_fin = size - (number+1);
        for num2 in (step_fin..size) {
            if(number > 0 && num2 == 11) {print!("And ");};
            println!("{}", days_gifts[num2]);
        }
        println!();
    }
}