# Variables and mutability
Vars are `const` by default, have to add `mut` to make them mutable

## Constants are basically C/C++ macros but only data types
`const MACRO_NAME: data_type =  expression_or_value`
They must be resolved at compile time!
Can't be shadowed as they are constant through all execution time
https://doc.rust-lang.org/reference/const_eval.html

## Variable Shadowing
You can redeclare a variable, changing its data type and mutability
This works like a stack when using scopes, in every scope the value can be shadowed but leaving a shadowed var in a scope will reveal the previous value out of scope.

## Data Types
Rust can infer data type by the functions and context, but most of the time it is essential that we sepcify value types

### Scalar Types - Numbers
Signed values use Twos Complement
 - 1st bit is negative/positive
 - Next bits generate a number
 - Number is summed to 0 if positve or summed to -max from the other bites
 - 001 = positve 0 + 1 = 1
 - 101 = negative min + 1 = -(11 to decimal + 1) + 01 = -4 + 1 = -3
#### Integer types
i8, i16, i32, i64, i128
u8, u16, u32, u64, u128
##### isize - usize
- Depending on processor / OS architecture, it will be a 32-64 bit value
##### Literals
Decuma, Hex, Octal, Binary, Byte(u8 - ubyte)

#### Overflow
In debug it will `panic!` whic his exit with an error
In release it will just overflow (from max to min, from min to max) looping around.

To explicitly handle the possibility of overflow, you can use these families of methods provided by the standard library for primitive numeric types:

 - Wrap in all modes with the wrapping_* methods, such as wrapping_add
 - Return the None value if there is overflow with the checked_* methods
 - Return the value and a boolean indicating whether there was overflow with the overflowing_* methods
 - Saturate at the value’s minimum or maximum values with saturating_* methods

#### Floating Point Types
f32 , f64 
single and double basically

#### Numeric Operations
Sum, difference, product, quotient, remainer.
Integer operations are floored
https://doc.rust-lang.org/book/appendix-02-operators.html

#### Booleans - bool
#### Character - 'char' - 4byte Unicode Scalar (more than ASCII <3)


### Compound Types
Multiple values in a single type

#### Tuple
Fixed length multi type
`let tup: (i32, f64, u8) = (500, 6.4, 1);`
Tuples will then store the types/vars in subvars like an array (tup.0, tup.1,...);
And can be destructure into multiple vars
`let (x, y, z) = tup;`
But we must make the number of variables it initializes to the number of variables it holds!

#### Array
Fixed length
`let a = [1, 2, 3, 4, 5];`
Can be pre_sized and set the vartype, but those 2 must be done at the same type:
`let a: [type;size] = [1,2,3,4,5];`
Or initialize a number of spaces to a value
`let a = [init_value; size];`