use std::fmt;
struct Wrapper(Vec<String>); // Wrapper is a tuple type over a Vec<String>

impl fmt::Display for Wrapper {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "[{}]", self.0.join(", "))
    }
}

fn main() {
    let w = Wrapper(vec![String::from("Hello"), String::from("world!")]);
    println!("w = {}", w); // Implictly use display for the Wrapper type, which in turn will do the job for the subtype Vec<String>

    println!("{}", w.0.join(", "));

    call_hello_macro();
}


// Using crate hello_macro
use hello_macro::HelloMacro; // Defines HelloMacro trait
use hello_macro_derive::HelloMacro; // Crate that defines the derivation of HelloMacro trait, to help users avoid the writing of the implementation block for the Trait

#[derive(HelloMacro)] // Derives the Trait
struct Pancakes;
// No implementation block is required!

fn call_hello_macro() { Pancakes::hello_macro(); } 
// hello_macro will print "Hello, Macro! My Name is TypeName!" where TypeName is the type which derives HelloMacro