extern crate proc_macro;

use proc_macro::TokenStream;
use quote::quote;
use syn;

#[proc_macro_derive(HelloMacro)]
pub fn hello_macro_derive(input: TokenStream) -> TokenStream {
    // Construct a representation of Rust code as a syntax tree
    // that we can manipulate
    let ast = syn::parse(input).unwrap(); // Returns DeriveInput struct, which is the parsed Rust Code
    // Use unwrap for simplicity, .parse() returns a `Result` which should be handled carefully

    // Build the trait implementation
    impl_hello_macro(&ast) // What actually transforms the AST into another block of code
}
// Calling #[derive(HelloMacro)] will actually call the linked function with #[proc_macro_derive(HelloMacro)] which will be hello_macro_derive()





// We take a `DeriveInput` as parameter, return a TokenStream
fn impl_hello_macro(ast: &syn::DeriveInput) -> TokenStream {
    let name = &ast.ident; // Get the string slice of the name!
    let gen = quote! { //quote! Allows us to store a block of Code!
        impl HelloMacro for #name { 
            // # means replace for the value in a variable, in the context of a `quote!`
            fn hello_macro() {
                println!("Hello, Macro! My name is {}!", stringify!(#name)); // another use of #
                // stringify! takes an expressiong and turns it into a string literal
            }
        }
    };
    gen.into() // .into() transforms the stored block of code into the Required type, in this case a TokenStream
}