struct Point {
    x: i32,
    y: i32,
}

fn main() {
    let p = Point { x:0, y: 7};
    let Point {x:a, y:b} = p; // Break into differently named variables
    println!("{} and {}", a, b);

    let Point{x,y} = p;
}

enum Message {
    Quit,
    Move { x: i32, y: i32 },
    Write(String),
    ChangeColor(i32, i32, i32),
}


fn destructure_enum() {
    let msg = Message::ChangeColor(0, 160, 255);

    match msg {
        Message::Quit => {
            println!("The Quit variant has no data to destructure.")
        }
        Message::Move { x, y } => {
            println!(
                "Move in the x direction {} and in the y direction {}",
                x, y
            );
        }
        Message::Write(text) => println!("Text message: {}", text),
        Message::ChangeColor(r, g, b) => println!(
            "Change the color to red {}, green {}, and blue {}",
            r, g, b
        ),
    }
}

#[derive(Debug)]
enum Color {
    Rgb(i32, i32, i32),
    Hsv(i32, i32, i32),
}

enum Message2 {
    Quit,
    Move { x: i32, y: i32 },
    Write(String),
    ChangeColor(Color),
}

fn destructure_nesteds() {
    let msg = Message2::ChangeColor(Color::Hsv(0, 160, 255));

    match msg {
        Message2::ChangeColor(Color::Rgb(r, g, b)) => println!(
            "Change the color to red {}, green {}, and blue {}",
            r, g, b
        ),
        Message2::ChangeColor(Color::Hsv(h, s, v)) => println!(
            "Change the color to hue {}, saturation {}, and value {}",
            h, s, v
        ),
        Message2::ChangeColor(color) => match color {
            Color::Rgb(r,g,b) => println!("Valid!"),
            Color::Hsv(h,s,v) => println!("Valid!"),
        },
        Message2::ChangeColor(color) => {},
        _ => (),
    }
}

enum SomeType {
    Type1((i32, i32), Point),
}
fn destructure_tuple_struct() {
        
    //let t1 = SomeType::Type1((10,10), Point{x:10, y:10});
    //match t1 {
    //    SomeType::Type1
    
    let t2 = ((10,10), Point{x:10, y:10});
    let ((feet, inches,), Point{x,y}) = t2;
    
    let v = (1,2,3,4,5);
    let (x,..,four, five) = v; // We ignore the rest

    let x = Some(8);
    match x {
        Some(4 | 5 | 6) => println!("yes"),
        Some(x) => (),
        //Some(n:val @ 7..10) => println!("aeswfaf"),
        None => (),
    }

    let point = Point{x: 10, y:10};

    match point {
        Point{x, y: o @ 9..=10} => println!("Shoudl print?"),
        _ => (),
    }

    //let tuple_t = (10,10);
    //match tuple_t {
    //    (x: t @ 9..=10, y) => (),
    //    (x,y) => (),
    //    (_,_) => (),
    //}
}