pub struct Post {
    content: String,
}

impl Post {
    pub fn new() -> DraftPost { // Generate a new Draft the intended way!
        DraftPost { content: String::new(), }
    }

    // Allow to return actual content
    pub fn content(&self) -> &str {
        &self.content
    }
}

pub struct DraftPost {
    content: String,
}

impl DraftPost {
    pub fn add_text(&mut self, text:&str) {
        self.content.push_str(text);
    }

    pub fn request_review(self) -> PendingReviewPost {
        PendingReviewPost {
            content: self.content,
            approvals: 0,
        }
    }
}

pub struct PendingReviewPost {
    content: String,
    approvals: u32,
}

impl PendingReviewPost {
    pub fn approve(mut self) -> Post {
        Post { content: self.content }
    }

    pub fn reject(self) -> DraftPost {
        DraftPost { content: self.content, }
    }
}
