# Extending Concurrency with `Sync` and `Send` traits
The Rust language has very few `concurrency` specific features. They are part of the standard library not language. You can still create your own primitives and features.

These are `std::marker` traits, meaning, that implementing them does not require implementing other methods, it jsut marks them as safe for the operations they entail.

## Allowing Transference of Ownership between Threads with `Send`
Remember we used `send(val)` to send a complete value and ownership was transferred, that implements `Send` trait.

## Allowing Access from Multiple Threads with `Sync`
The `Sync` marker trait, tells that it is safe for the type to be referenced from multiple threads.

## Actually Implementing `Send` and `Sync` - UNSAFE
Types that are made of `Send` and `Sync` types, become automatically `Sync` and `Send` safe. They don't have to be implemented manually.

Actually implementing the type on one that uses non-safe `Send/Sync` types, requires that the methods and functions implemented on the type, are manually made to be safe in the multithreaded environments, which most likely involves you using unsafe code.

More on the [Rustonomoicon](https://doc.rust-lang.org/nomicon/index.html)