# Running code on Cleanup with `Drop` Trait
Customize what happens when a variable goes out of scope (CleanUp or Destructor methods but called automatically).
```rust
struct CustomSmartPointer {
    data: String,
}

impl Drop for CustomSmartPointer {
    fn drop(&mut self) {
        println!("Dropping CustomSmartPointer with data `{}`!", self.data);
    }
}

fn main() {
    let c = CustomSmartPointer {
        data: String::from("my stuff"),
    };
    let d = CustomSmartPointer {
        data: String::from("other stuff"),
    };
    println!("CustomSmartPointers created.");
}
```
When running this, the drop methods will be called when values go out of scope, printing their data.
```
CustomSmartPointers created.
Dropping CustomSmartPointer with data `other stuff`!
Dropping CustomSmartPointer with data `my stuff`!
```

## Dropping a Value Early - `std::mem::drop`
Ex: You have a lock that manages when access to variables is permitted. You might want to clear the lock as soon as we are done using that variable aso that it becomes accessible to others.

You can't call `.drop()` method directly, as it is used as a `Destructor` that would also be called after the variable goes out of scope.

To do that call `std::mem::drop(variable)` or use variable specific scopes, whatever feels cleaner to you.