# Objectives of Chapter 14
 - Customize profiles
 - Publishing on [](https://crates.io/)
 - Organizing in workspaces
 - Install Binaries from [](https://crates.io/)
 - Extend Cargo with custom commands

===

# Customizing Builds with Release Profiles
`dev` -> "Debug" Unoptimized with Debug Info Profile -> `cargo build`
`release` -> Release Optimized Profile -> `cargo build --release`

In `Cargo.toml` you can add [profile.*] sections to specify new profiles or override settings, for example:
```rust
[profile.dev]
opt-level = 0

[profile.release]
opt-level = 3
```

# Publishing a Crate to Crates.io

### Useful Documentation Comments
 - Document packages
 - `///` Documentation Comment (not `//` which is normal comment)
 - Give an example per function
 - `cargo doc` -> Generates html documentation
    - `--open` option opens it after building it
 - Documentation parses Markdown <3

### Common Sections
 - Panics -> Describe Scenarios in which the fun might panic
 - Errors -> Describe `Err` types if it returns a `Result`
 - Safety -> If function is `unsafe` -> Explain what the caller should do to keep usage safe

### Comments as Tests
`cargo test` runs the examples in the library!

### Commenting Contained Items
`//!` Adds documentation to the item that contains the comment, not the item the comment follows
```rust
//! # Doc My Crate
//! `my_crate` description

/// Comment about some fun
```
A section for fun will be created after the `//!` lines, and those before will be explaining the module for example instead of specific function or struct data.

## Exporting a Convenient Public API with `pub use`
Item Re-exporting!
```rust
// Ex:
use my_crate::some_module::another_module::UsefulType;
// Ew, bad, long, boring

// lib.rs
pub use self::some_module::another_module::UsefulType;

// user_code.rs
use crate::UsefulType;
// Wow, fast, good, direct
```
You have to figure out which types are most used and practical to use directly, then re-export them to facilitate its usage!

The documentation will list and link to the Re-exported items, so they will be easy to find and get used to.

## Setting up a Crates.io Account
Create account
Create New API Token
`cargo login <token>` on the repo

## Adding Metadata to a New Crate
```rust
// Cargo.toml
[package] // Where the metadata is set
name = ""
description = "" 
license = <[License Identifier Value](https://spdx.org/licenses/)>
```

## Publishing on Crates.io
`cargo publish`
This is permament, it can't be deleted, but you can keep overriding the version unlimitedly.

I've had to use `--allow-dirty` option as I am not using git to keep track of this, it is folder per folder.

### Publishing new Version
Change `version` value and run `cargo publish` again

### "Removing" Versions with `Yank`
Yank does not really delete it, it just takes it out of the usage for new users. Proejcts that already used it and depended on it can still download it and use it.
`cargo yank --vers 0.1.0`
`--undo` to undo a yank
