fn main() {
    let simulated_user_specified_value = 10;
    let simulated_random_number = 7;

    generate_workout(simulated_user_specified_value, simulated_random_number);
}

use std::thread;
use std::time::Duration;

fn simulated_expensive_calculation(intensity: u32) -> u32 {
    println!("calculating slowly...");
    thread::sleep(Duration::from_secs(2));
    intensity
}

use std::collections::HashMap;

struct Cacher<T,R>
where
    T: Fn(&R) -> R,
{
    calculation: T,
    value: HashMap<R, R>,
}

impl<T, R> Cacher<T, R>
    where 
        T: Fn(&R) -> R,
        R: std::cmp::Eq + std::hash::Hash + Clone,
{
    fn new(calculation: T) -> Cacher<T, R> {
        Cacher {calculation, value: HashMap::new()}
    }

    fn value(&mut self, arg:&R) -> R {
        if let Some(ret) = self.value.get(arg) { 
            return ret.clone()
        }
        else {
            let v = (self.calculation)(&arg);
            if let Some(ret) = self.value.insert(arg.clone(), v.clone()) {
                ret
            } else { v }
        }
    }
}

fn generate_workout(intensity: u32, random_number: u32) {
    /*
    let expensive_closure = |num| {
        println!("calculating slowly...");
        thread::sleep(Duration::from_secs(2));
        num
    };
    let mut cache_v = Cacher::new(expensive_closure);
    */
    let mut cache_v = Cacher::new(|&num| {
        println!("calculating slowly...");
        thread::sleep(Duration::from_secs(2));
        num
    });

    if intensity < 25 {
        println!(
            "Today, do {} pushups!",
            
            cache_v.value(&intensity)
        );
        println!(
            "Next, do {} situps!",
            cache_v.value(&intensity)
        );
    } else {
        if random_number == 3 {
            println!("Take a break today! Remember to stay hydrated!");
        } else {
            println!(
                "Today, run for {} minutes!",
                cache_v.value(&intensity)
            );
        }
    }
}