use std::env; // Not needed as std can be used directly, but would be shorter
use std::process;
use mini_grep::Config;

fn main() {
    println!("Start the program!");

    // Obtaining the arguments
    let _config = Config::new(env::args()).unwrap_or_else(|err| {
        println!("Error parsing arguments: {}", err);
        process::exit(1); // Stop execution with error number
    });

    println!("{:?}", _config);

    mini_grep::run(_config).unwrap_or_else(|err| {
        println!("App Error: {}", err);
        process::exit(1);
    });
}




