# Test Organization
 - Unit Tests -> small, focused, testing one module in isolation, using private and public interfaces
 - Integration Tests -> External to the library, uses code as any other external code would, public interface only and using multiple modules per test

## Unit Tests
Test each unit of code in isolation -> Add a `tests` module in each file that will contain the test functions

### `#[cfg(test)]` - Test Module
This attribute tells rust that module only when doing `cargo test`, not when building or running the project.

### Testing Private Functions
Rust allow sit, but it is up to you if you want to test private code that the end user of the library or crate will see.


## Integration Tests
External to the project. Can only use the `public` API
They will only run if the UNIT tests pass!

Make a new folder at the same level as `src`, named `tests`
Each file inside will become a separate `crate` that will test, should do `use::lib_name` to get functionality like any external project

## Submodules in Integration Tests
Some code will be inevitably shared between integration tests, that could be extracted into a "global" or `common` module.
If you just add a file called `common.rs` it will be treated as a test even if it does not have any test functions.

Add `tests/common/mod.rs` -> Convention which makes things in subdirectories of `tests` not be treated as tests, can be used now as proper submodules.

## Integration Tests for Binary Crates
Only library crates can use integration tests.