fn main()
{
    function_deduplication();
}

fn largest(list: &[i32]) -> i32 {
    let mut largest = list[0];
    for &item in list {
        if item > largest {
            largest = item;
        }
    }

    largest
}


/*fn largest_t<T>(list: &[T]) -> T {
    let mut largest = list[0];
    for &item in list {
        if item > largest {
            largest = item;
        }
    }
    largest
}*/

fn largest_t<T: PartialOrd + Copy>(list: &[T]) -> T {
    let mut largest = list[0];
    for &item in list {
        if item > largest {
            largest = item;
        }
    }
    largest
}

fn largest_t2<T: PartialOrd>(list: &[T]) -> &T {
    let mut largest = &list[0];
    let mut count = 0;
    for _item in list {
        count += 1;
    }
    for number in (0..count) {
        if *largest < list[number] {
            largest = &list[number];
        }
    }
    largest
}

fn function_deduplication() {
    let number_list = vec![34,50,25,10,65];
    let result = largest(&number_list);
    let number_list = vec![102, 34, 6000, 89, 54, 2, 43, 8];
    let result = largest(&number_list);
    // Imagine having to copy paste and change things for each time needed
}

use std::mem;
fn longest<'a>(str1: &'a str, str2: &'a str) -> &'a str {
    if(str1.len() > str2.len())
    {
        str1
    }
    else {
        str2
    }
}

