# Separating modules in different files

Modules can be declared, rather than defined/ Then we define the module in a file that has the same name:
```rust
// src/lib.rs
mod front_of_house;

pub use crate::front_of_house::hosting;

pub fn eat_at_restaurant() {
    hosting::add_to_waitlist();
    hosting::add_to_waitlist();
    hosting::add_to_waitlist();
}

// src/front_of_house.rs
pub mod hosting; // The file acts as a "crate" as said before

// src/front_of_house/hosting.rs 
pub fn add_to_waitlist() {}

// hosting.rs is set in a folder that "acts" like the crate holding the definitions made in front_of_house.rs
// the .rs file acts as the "namespace" directly!
```