# Managing Growing Projects with Packages, Crates and Modules
**Packages**: A Cargo feature that lets you build, test, and share crates
**Crates**: A tree of modules that produces a library or executable
**Modules** and use: Let you control the organization, scope, and privacy of paths
**Paths**: A way of naming an item, such as a struct, function, or module

# Packages and Crates

## Crate
Binary or Library
`Create root` is where the code start running from in that binary

## Package
A Combination of 1 library and many binaries, but must contain at least 1 crate

## Ex:
```bash
$ cargo new my-project
     Created binary (application) `my-project` package
$ ls my-project
Cargo.toml
src
$ ls my-project/src
main.rs
```
Creatign a new project generates a set of files, `Cargo.toml` indicates the package base.
A `crate` is a collection of files, suhc as the ones in src `main.rs`. By default the build system just uses the base files it has, so it had a `lib.rs` it would contain a library instead of a binary?

Crates are to join functionality together (so a crate is like a library called in C/C++).

# Defining Modules to Control Scope and Privacy
Each binary and library may be under different scopes/namespaces, as well as have a different set view, public or private.

```rust
mod module_name {
    mod submodule_name {
        fn fun1(){}
        //...
    }
    //...
    struct struct_name {}
    const var: type = asdasd;
    enum enum_name {
        Enum1,
    }
    // Traits??
}
```
Basically a `module` is a namespace.
And this is hierarchical, to a base `module` that would be the `crate`.

# Paths for Referring to an item in the Module Tree

If we want to use things in the module, call it with `::`
Ex: `front_of_house::serving::take_order()`
Ex2: Absolute path = `**crate**::front_of_house::serving::take_order()`

`crate` or crate_name is used to know which binary/library we are using (in this case the same one we are at so `crate` directly is valid).

But if we want something to be seen out of the library, it has to be marked with `pub`, as everything is private by default even in the same file

Privacy is relative to hierarchy. Child members have knowledge of their parents, but parents do not allow their child to be publicly viewed by default.

For childs to use things outside their scope, start with `super` which is like `../` in path terminology.

## Making Structs and Enums public

`pub` before a structs makes it public, but not its fields... have ot add `pub` to each field...

Enum become all public when using `pub` before them.