# Using derivates
Structs can implement other struct, types and traits.
In the latter case, we use
```rust
#[derive(Trait)]
struct StructName{}
```
This will make the struct acquire the trait.
Ex:
```rust
struct st1{}

#[derive(Debug)]
struct st2{}

...
println!("{:?} {:?}", st1, st2;)
...
```
1st, `:?` means to use a set format for the type, which must be a trait.
`st1` will not print, as it is not marked with a format to print
`st2` derives the `Debug` trait to make it be able to print in a Debug style when formatted.
```rust
// Example log from a formatted type
Rectangle { width: 30, height: 50 }
```

`:#?` is similar to `:?` but prettier (better spaced and more readble)

```rust
rect1 is Rectangle {
    width: 30,
    height: 50,
}
```

To print `Debug` information, we can also use `dbg!(&var);` which is more direct. It also return ownership of what is being passed, so if you can debug the result of an expression and set it somewhere.
```rust
    let scale = 2;
    let rect1 = Rectangle {
        width: dbg!(30 * scale),
        height: 50,
    };

    dbg!(&rect1);

//---
[src/main.rs:10] 30 * scale = 60
[src/main.rs:14] &rect1 = Rectangle {
    width: 60,
    height: 50,
}
```

There are many more derivable traits like and very different from `Debug`
https://doc.rust-lang.org/book/appendix-03-derivable-traits.html

 More attributes to use other than `derive` 
https://doc.rust-lang.org/reference/attributes.html

---

# Method Syntax

Struct automatically implement a type called `self`, which basically is used to pass its own information to their methods (like in C/C++ with `this`).

To define methods to implement we have to create an implementation zone:
```rust
impl Rectangle {
    fn area(&self) -> u32 {
        self.width * self.height
    }
}
```
Inside this implementation we can declare functions that use self to make them be methods usable by the type. Instead of `&Rectangle` we just reference itself so that no info has to be passed down, it uses its own data.

This borrows the `self` mutably or immutably, like any other functions, so now that has the ownership of the variable.

## Multiple parameters
Like a function, add parameters to the method after `&self`/`&mut self`(if we want to modify self in the method).
```rust
fn can_hold(&self, cmp: &Rectangle) -> bool {
        (self.width > cmp.width && self.height > cmp.width) 
        || (self.width > cmp.height && self.height > cmp.width)
    }
```

## Associated Functions
Basically not use `self`, would be like a `static` function in a C++ Class, or a functor in a C `struct`.
Then to call them we use the `StructType::function()` syntax instead.

## Separate implementation blocks
You don't have to write all the implemented methods and functions in a single `impl` block. You can separate them!