# STRUCTS
Similar to `Tuple` get multiple data types in a single "variable". More like defining a new variable type.

``` rust
// Form
struct DataType_Name {
    variable_name: data_type,
    //...
}
// Ex:
struct User {
    active: bool,
    username: String,
    email: String,
    sign_in_count: u64,
}

// Initialization
let var = User {
    email: String::from("someone@example.com"),
    username: String::from("someusername123"),
    active: true,
    sign_in_count: 1,
};

```
As seen, each member/data inside a struct is a KVP (Key-Value Pair), so you can initialize it not sequentially. 

To get things from a struct `var.value`  in dot notation.

All structs are mutable by default.
You can initialize a variable without having to reference the key, if the variable name is the same as the key
``` rust
let email = "someone@example.com";
let var = User {
    email,
};
// Initialize email with var email

fn build_user(email: String, username: String) -> User {
    User {
        email,
        username,
        active: true,
        sign_in_count: 1,
    }
}
```
### Instances with Struct Update Syntax
You can move other vars of the same struct_type and just initialize the ones you need to generate a new one.

``` rust
// This one copies it
let user2 = User {
    active: user1.active,
    username: user1.username,
    email: String::from("another@example.com"),
    sign_in_count: user1.sign_in_count,
};

// This one uses Struct Update Syntax, it moves ownership of the fields to user2
 let user2 = User {
    email: String::from("another@example.com"),
    ..user1 // ..other var to just grab the same fields from the other var
};
```
In the 2nd, we are generating an instanc with the same values except email, but we lose validity to `user1` becuse that uses `move` syntax.

This happens on types that do not implement `Copy` trait, so they are `Move`d form variable to variable. `active` and `sign_in_count` are `Copy` trait vars, so they are copied and will remain valid.

## TUPLE Structs
Structs similar to tuples, basically a struct with no associated keys.
```rust
struct ColorRGB(i32, i32, i32);
struct Point(i32, i32, i32);

let black = ColorRGB(0,0,0);
// println!("{}", black.1);
let origin = Point(0,0,0);

println!("{} {}", black.0, origin.0);
```

## UNIT Structs
`struct AlwaysEqual;`
This basically accomplishes the task of doing nothing, but can be done.
basically we can have it equal to a type that holds nothing, but can have different traits -> later on.

## Lifetimes
Instead of using a `&str` it was used a `String`, so that ownership is completely moved from one to other. But we would rather have references to objects instead of messing up with ownership.

Later on, the lifetimes are explained, just know that for a struct to have a valid access or ownerhip of references, they have to specify until which moment the ownership of that reference will be valid.