# Functions
```
fn function_name_snake_case(varname: data_type, other_var: data_type) {
    // do things
}
```

### Statements
Do not return a value -> `let x = "caca"` -> is evaluating and puting value to x but does not return anything

### Expressions
Do return a value
`let x = 3 + 4;` -> `3+4` is an expression
Calling functions, macros,... are basically expressions as they do return a value
```
fn main() {
    let y = {
        let x = 3;
        x + 1
    };
    // Inside the {} it is a returning expression that initializes y, and x is left locally

    println!("The value of y is: {}", y); // Is an expression that may return an error value or do something
    // The ; will mean an expression ends and the value has already been used and not returned any further
}
```

#### Function Return Value
`fn function() -> data_type { expression_var_or_something }`
The last line without `;` will be an expression that evaluates to the return `data_type` sepcified after `->`

```
fn five() -> i32 {
    5
}

fn main() {
    let x = five();

    println!("The value of x is: {}", x);
}
```

If the last line of a function with a specified return type, has a `;` then it will cause a compile error as it is implicitly returning a `()` emtpy value that can't be used for the specified return type.

## Control flow

### If - Else

Same as C/C++, but condition **MUST** be a `bool`
We can't check with random types, existance and such.
`()` are not necessary but are needed to display conditional checking order like in arithmetic

IfElse can be used in other statements, as it then executes an {expression} than can return a value.
`let x = if 10 < 0 {5} else {6};`
But the data_types of the resulting expressions **MUST** match (priority in the first block)

### Loops

#### loop
directly loop forever, can on be exited with error, crash, panic or `break`

`continue` -> skip the rest of the code until the `}` and start a new iteration on the existing loop

We can label loops, then accordingly lable the `continue` and `break` to specify the action in every loop.
```rust
'loopname1: loop {
    'loopname2: loop{
        if a == 0 {
            break; // breaks the most inner loop, does not regard labels
        }
        else {
            break 'loopname1; // breaks the first loop as it is specifically telling it
        }
    }
}
```

You can also set a return value to the break
```rust
break `loopname {expression};
break expression; // if not specifying a loopname
```

#### while
`while (condition) {}`
same as a C/C++ while, still can implement `continue` and `break` inside shown previously


#### for
`for element in collection {}`
This default iterates over every element of the collection

`for number in (1..4).rev() {}`
This executes a for 4 times, using number as a variable index
As we use `.rev()` in the range, we reverse the order so
It will be: `4,3,2,1` for number in each subsequent iteration
This is a controlled way of doing 4 iterations and having the index

### RANGES
we define a range by `x...y` where `y > x`
This can be used to iterate by a number range as seen previously, but also for other things seen later. in `Slices`