# Developing the Lib with Test-Driven Development
Before writing the functionality:
 - Write 1 test function
 - Write functionality so that it fails
 - Refactor so that it succeeds
 - Write/Refactor fun
 - Repeat

## Test and Failing Function
Write a test that would file the intent:
```rust
// test module mumbo jumbo...
fn one_result() {
    let query = "duct";
    let contents = "\
        Rust: 
        safe, fast, productive. 
        Pick three.";

    assert_eq!(vec!["safe, fast, productive."], search(query, contents));
}

// Then the fun that should fail the test
// We tell that The borrow placed in the vectors, has the same lifetime as the string used to pass the contents, which we are borrowing from
pub fn search<'a>(query: &str, contents: &'a str) -> Vec<&'a str> {
    vec![]
}
```
The fun now will fail the test as it returns an empty vector!

## Make function succeed!
What does it need to do:
 - Go through each line of the text
 - Check if the line contains the query string
 - Ok -> Add to List
 - Err -> Nothing
 - Return list of lines containing it.
```rust
pub fn search<'a>(query: &str, contents: &'a str) -> Vec<&'a str> {
    // Create the return variable, mutable because we will add items to it
    let mut ret: Vec<&str> = Vec::new(); 
    for line in contents.lines() { //lines() converts into a collection of lines
        if line.contains(query){ //Check if query is contained
            ret.push(line.trim());// add to list if it is, trim spaces at start and end
        }
    }
    ret // Return list of lines containing query
}
```

Now it works, test with the whole program!